"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
const Validate_1 = require("../Validate/Validate");
class Proximity {
    constructor(messagePrefix) {
        this.messagePrefix = messagePrefix;
        this.lastDetected = false;
        this.eventEmitter = new events_1.EventEmitter();
    }
    onStateChange(callback) {
        Validate_1.default({ callback }).required().function();
        if (this.lastDetected) {
            callback(this.lastDetected);
        }
        this.eventEmitter.addListener('change', callback);
        return () => this.eventEmitter.removeListener('change', callback);
    }
    handleMessageData(data) {
        switch (data.type) {
            case this.getMessage('change'):
                if (data.detected !== this.lastDetected) {
                    this.lastDetected = data.detected;
                    this.eventEmitter.emit('change', data.detected);
                }
                break;
            default:
        }
    }
    getMessage(name) {
        return this.messagePrefix + '.' + Proximity.MESSAGE_PREFIX + '.' + name;
    }
}
exports.default = Proximity;
Proximity.MESSAGE_PREFIX = 'proximity';
//# sourceMappingURL=Proximity.js.map