"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const Validate_1 = require("../Validate/Validate");
const ProofOfPlayType_1 = require("./ProofOfPlayType");
class ProofOfPlay {
    constructor(commandApi) {
        this.commandApi = commandApi;
    }
    recordItemPlayed({ name, customId, type, tags, fileName, playbackSuccess, errorMessage }) {
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ name }).required().string();
            Validate_1.default({ customId }).string();
            Validate_1.default({ type }).string(['video', 'image', 'html', 'custom']);
            Validate_1.default({ tags }).array('string');
            Validate_1.default({ fileName }).string();
            Validate_1.default({ playbackSuccess }).boolean();
            Validate_1.default({ errorMessage }).string();
            yield this.commandApi.dispatch({
                type: ProofOfPlayType_1.default.ItemPlayed,
                itemName: name,
                customId,
                itemType: type,
                itemTags: tags,
                fileName,
                playbackSuccess,
                errorMessage,
            });
        });
    }
}
exports.default = ProofOfPlay;
//# sourceMappingURL=ProofOfPlay.js.map