"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class JavascriptLoadFileController {
    constructor(window) {
        this.window = window;
        this.name = 'javascript';
    }
    load(filePath, element) {
        return new Promise((resolve, reject) => {
            const scriptTag = this.window.document.createElement('script');
            scriptTag.setAttribute('type', 'text/javascript');
            scriptTag.setAttribute('src', filePath);
            scriptTag.onerror = () => {
                reject(new Error('File "' + filePath + '" cannot be loaded'));
            };
            scriptTag.onload = () => {
                console.info('File ' + filePath.substring(0, 100) + ' was loaded');
                resolve();
            };
            element.appendChild(scriptTag);
        });
    }
}
exports.default = JavascriptLoadFileController;
//# sourceMappingURL=JavascriptLoadFileController.js.map