"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class CssLoadFileController {
    constructor(window) {
        this.window = window;
        this.name = 'css';
    }
    load(filePath, element) {
        return new Promise((resolve, reject) => {
            const linkTag = this.window.document.createElement('link');
            linkTag.setAttribute('type', 'text/css');
            linkTag.setAttribute('rel', 'stylesheet');
            linkTag.setAttribute('href', filePath);
            linkTag.onerror = () => {
                reject(new Error('File "' + filePath + '" cannot be loaded'));
            };
            linkTag.onload = () => {
                console.info('File ' + filePath.substring(0, 100) + ' was loaded');
                resolve();
            };
            element.appendChild(linkTag);
        });
    }
}
exports.default = CssLoadFileController;
//# sourceMappingURL=CssLoadFileController.js.map