"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VISaveFile = void 0;
const IFileType_1 = require("./IFileType");
const IFlag_1 = require("./Flags/IFlag");
const ErrorCodes_1 = require("../Error/ErrorCodes");
const ErrorCodesMessages_1 = require("../Error/ErrorCodesMessages");
exports.VISaveFile = {
    uid: { 'string': null, 'error': {
            code: ErrorCodes_1.default.FILE_DOES_NOT_HAVE_UID,
            message: ErrorCodesMessages_1.default[ErrorCodes_1.default.FILE_DOES_NOT_HAVE_UID],
        },
    },
    uri: 'string',
    type: { 'string': IFileType_1.VIFileType, 'error': {
            code: ErrorCodes_1.default.FILE_FLAGS_ARE_NOT_IN_ARRAY,
            message: ErrorCodesMessages_1.default[ErrorCodes_1.default.FILE_FLAGS_ARE_NOT_IN_ARRAY],
        },
    },
    headers: '?object',
    flags: { '?array': {
            'object': IFlag_1.VIFlag,
            'error': { code: ErrorCodes_1.default.FILE_FLAG_IS_NOT_OBJECT, message: ErrorCodesMessages_1.default[ErrorCodes_1.default.FILE_FLAG_IS_NOT_OBJECT] },
        },
    },
};
//# sourceMappingURL=ISaveFile.js.map