"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validatePinCode = exports.generateRandomPin = void 0;
const AppletSecurityError_1 = require("../../Error/AppletSecurityError");
const ErrorCodes_1 = require("../../../FrontApplet/Error/ErrorCodes");
const ErrorSuggestions_1 = require("../../../FrontApplet/Error/ErrorSuggestions");
function generateRandomPin() {
    return Math.floor(Math.random() * 1e4).toString().padStart(4, '0');
}
exports.generateRandomPin = generateRandomPin;
function validatePinCode(pinCode) {
    if (!pinCode.match(/^\d{4}$/)) {
        throw new AppletSecurityError_1.default({
            kind: 'appletSecurityError',
            message: `Invalid PIN code: ${pinCode}`,
            code: ErrorCodes_1.default.SECURITY_PIN_CODE_INVALID,
            suggestion: ErrorSuggestions_1.default.SECURITY_PIN_CODE_FORMAT,
        });
    }
}
exports.validatePinCode = validatePinCode;
//# sourceMappingURL=SecurityHelper.js.map