import IPostMessage from '../IPostMessage';
import IWifiMessage, { WifiEvent } from './IWifiEvent';
import { IWifiDevice } from './INetworkInfo';
export interface IWifiConnectOptions {
    hidden?: boolean;
}
export declare const VIWifiConnectOptions: {
    hidden: string;
};
export default class Wifi {
    private messagePrefix;
    private postMessage;
    static MESSAGE_PREFIX: string;
    private eventEmitter;
    constructor(messagePrefix: string, postMessage: IPostMessage<any>);
    isClientEnabled(): Promise<boolean>;
    enableClient(): Promise<void>;
    isAPEnabled(): Promise<boolean>;
    enableAP(ssid: string, password: string): Promise<void>;
    disable(): Promise<void>;
    getConnectedTo(): Promise<IWifiDevice | null>;
    /**
     * Connect to a Wi-Fi network
     * @param ssid
     * @param password
     * @param options
     */
    connect(ssid: string, password?: string, options?: IWifiConnectOptions): Promise<void>;
    disconnect(): Promise<void>;
    getCountry(): Promise<string | null>;
    setCountry(countryCode: string): Promise<void>;
    scanDevices(): Promise<{
        ssid: string;
        encrypted: boolean;
    }[]>;
    on(event: WifiEvent, listener: (...args: []) => void): void;
    once(event: WifiEvent, listener: (...args: []) => void): void;
    removeListener(event: WifiEvent, listener: (...args: []) => void): void;
    removeAllListeners(event?: WifiEvent): void;
    handleMessageData(data: IWifiMessage): void;
    private getMessage;
}
