"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const SecurityHelper_1 = require("./helpers/SecurityHelper");
class Security {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
    }
    /**
     * Get PIN code
     * @returns 4 digits number string
     */
    getPinCode() {
        return __awaiter(this, void 0, void 0, function* () {
            const { pinCode } = yield this.postMessage({
                type: this.getMessage('get_pin_code'),
            });
            return pinCode;
        });
    }
    /**
     * Set PIN code
     * @param pinCode 4 digits number string
     */
    setPinCode(pinCode) {
        return __awaiter(this, void 0, void 0, function* () {
            SecurityHelper_1.validatePinCode(pinCode);
            yield this.postMessage({
                type: this.getMessage('set_pin_code'),
                pinCode,
            });
        });
    }
    /**
     * Generate 4 digits number string and set it as PIN code
     */
    generateRandomPinCode() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.setPinCode(SecurityHelper_1.generateRandomPin());
        });
    }
    getMessage(name) {
        return this.messagePrefix + '.' + name;
    }
}
exports.default = Security;
//# sourceMappingURL=Security.js.map