import IPostMessage from '../IPostMessage';
export default class Security {
    private messagePrefix;
    private postMessage;
    constructor(messagePrefix: string, postMessage: IPostMessage<any>);
    /**
     * Get PIN code
     * @returns 4 digits number string
     */
    getPinCode(): Promise<string>;
    /**
     * Set PIN code
     * @param pinCode 4 digits number string
     */
    setPinCode(pinCode: string): Promise<void>;
    /**
     * Generate 4 digits number string and set it as PIN code
     */
    generateRandomPinCode(): Promise<void>;
    private getMessage;
}
