"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const DeviceHelper_1 = require("./helpers/DeviceHelper");
const VideoHelper_1 = require("./helpers/VideoHelper");
const Validate_1 = require("../Validate/Validate");
class Screen {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
    }
    resize(baseUrl, orientation, resolution, currentVersion, videoOrientation) {
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ baseUrl }).required().uri();
            Validate_1.default({ currentVersion }).required().string();
            if (typeof DeviceHelper_1.Orientation[orientation] === 'undefined') {
                throw new Error('Invalid orientation');
            }
            if (typeof DeviceHelper_1.Resolution[resolution] === 'undefined') {
                throw new Error('Invalid resolution');
            }
            if (videoOrientation && typeof VideoHelper_1.Orientation[videoOrientation] === 'undefined') {
                throw new Error('Invalid video orientation');
            }
            yield this.postMessage({
                type: this.getMessage('resize_screen'),
                baseUrl,
                orientation,
                resolution,
                currentVersion,
                videoOrientation,
            });
        });
    }
    getOrientation() {
        return __awaiter(this, void 0, void 0, function* () {
            const { screenOrientation } = yield this.postMessage({
                type: this.getMessage('get_screen_orientation'),
            });
            return screenOrientation;
        });
    }
    setBrightness(timeFrom1, brightness1, timeFrom2, brightness2) {
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ brightness1 }).required().number().min(0).max(100);
            Validate_1.default({ brightness2 }).required().number().min(0).max(100);
            Validate_1.default({ timeFrom1 }).canBeNull().required().string().matchRegExp(/\d{2}:\d{2}/).timerTime();
            Validate_1.default({ timeFrom2 }).canBeNull().required().string().matchRegExp(/\d{2}:\d{2}/).timerTime();
            yield this.postMessage({
                type: this.getMessage('set_screen_brightness'),
                timeFrom1,
                brightness1,
                timeFrom2,
                brightness2,
            });
        });
    }
    getBrightness() {
        return __awaiter(this, void 0, void 0, function* () {
            const { screenBrightness } = yield this.postMessage({
                type: this.getMessage('get_screen_brightness'),
            });
            return screenBrightness;
        });
    }
    takeAndUploadScreenshot(uploadBaseUrl) {
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ uploadBaseUrl }).required().uri();
            const { screenshotUrl } = yield this.postMessage({
                type: this.getMessage('upload_screenshot'),
                uploadBaseUrl,
            });
            return screenshotUrl;
        });
    }
    powerOn() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.postMessage({
                type: this.getMessage('power_on_display'),
            });
        });
    }
    powerOff() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.postMessage({
                type: this.getMessage('power_off_display'),
            });
        });
    }
    isPoweredOn() {
        return __awaiter(this, void 0, void 0, function* () {
            const { isDisplayPowerOn } = yield this.postMessage({
                type: this.getMessage('get_is_display_power_on'),
            });
            return isDisplayPowerOn;
        });
    }
    getMessage(name) {
        return this.getMessagePrefix() + '.' + name;
    }
    getMessagePrefix() {
        return this.messagePrefix;
    }
}
exports.default = Screen;
//# sourceMappingURL=Screen.js.map