import IPostMessage from '../IPostMessage';
import IBrightness from './IBrightness';
import IOrientation from './IOrientation';
export default class Screen {
    private messagePrefix;
    private postMessage;
    constructor(messagePrefix: string, postMessage: IPostMessage<any>);
    resize(baseUrl: string, orientation: string, resolution: string, currentVersion: string, videoOrientation?: string): Promise<void>;
    getOrientation(): Promise<IOrientation>;
    setBrightness(timeFrom1: string, brightness1: number, timeFrom2: string, brightness2: number): Promise<void>;
    getBrightness(): Promise<IBrightness>;
    takeAndUploadScreenshot(uploadBaseUrl: string): Promise<string>;
    powerOn(): Promise<void>;
    powerOff(): Promise<void>;
    isPoweredOn(): Promise<boolean>;
    private getMessage;
    private getMessagePrefix;
}
