"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
class RemoteControl {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
    }
    enable() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.setEnabled(true);
        });
    }
    disable() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.setEnabled(false);
        });
    }
    isEnabled() {
        return __awaiter(this, void 0, void 0, function* () {
            const { isRemoteControlEnabled } = yield this.postMessage({
                type: this.getMessage('get_is_remote_control_enabled'),
            });
            return isRemoteControlEnabled;
        });
    }
    lock() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.disable();
        });
    }
    unlock() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.enable();
        });
    }
    isLocked() {
        return this.isEnabled();
    }
    setEnabled(enabled) {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.postMessage({
                type: this.getMessage('set_remote_control_enabled'),
                enabled,
            });
        });
    }
    getMessage(name) {
        return this.messagePrefix + '.' + name;
    }
}
exports.default = RemoteControl;
//# sourceMappingURL=RemoteControl.js.map