"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const TimerHelper_1 = require("./helpers/TimerHelper");
const Validate_1 = require("../Validate/Validate");
class Power {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
    }
    systemReboot() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.postMessage({
                type: this.getMessage('reboot_system'),
            });
        });
    }
    appRestart() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.postMessage({
                type: this.getMessage('restart_app'),
            });
        });
    }
    getTimers() {
        return __awaiter(this, void 0, void 0, function* () {
            const { timers } = yield this.postMessage({
                type: this.getMessage('get_timers'),
            });
            return timers;
        });
    }
    setTimer(type, timeOn, timeOff, weekdays, volume) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof TimerHelper_1.TimerType[type] === 'undefined') {
                throw new Error('Invalid timer type');
            }
            Validate_1.default({ timeOn }).canBeNull().required().string().matchRegExp(/\d{2}:\d{2}:\d{2}/).timerTime();
            Validate_1.default({ timeOff }).canBeNull().required().string().matchRegExp(/\d{2}:\d{2}:\d{2}/).timerTime();
            Validate_1.default({ weekdays }).required().array('string');
            Validate_1.default({ volume }).required().number().min(0).max(100);
            for (const weekday of weekdays) {
                if (typeof TimerHelper_1.TimerWeekday[weekday] === 'undefined') {
                    throw new Error('Invalid timer weekday');
                }
            }
            yield this.postMessage({
                type: this.getMessage('set_timer'),
                timerType: type,
                timeOn,
                timeOff,
                weekdays,
                volume,
            });
        });
    }
    unsetTimer(type) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof TimerHelper_1.TimerType[type] === 'undefined') {
                console.warn('Invalid timer type');
            }
            yield this.setTimer(type, null, null, [], 0);
        });
    }
    getProprietaryTimers() {
        return __awaiter(this, void 0, void 0, function* () {
            const { timers } = yield this.postMessage({
                type: this.getMessage('get_proprietary_timers'),
            });
            return timers;
        });
    }
    setProprietaryTimer(type, timeOn, timeOff, weekdays) {
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ type }).required().string().matchRegExp(/^TIMER_\d+$/);
            Validate_1.default({ timeOn }).canBeNull().required().string().matchRegExp(/\d{2}:\d{2}:\d{2}/).timerTime();
            Validate_1.default({ timeOff }).canBeNull().required().string().matchRegExp(/\d{2}:\d{2}:\d{2}/).timerTime();
            Validate_1.default({ weekdays }).required().array('string');
            for (const weekday of weekdays) {
                if (typeof TimerHelper_1.TimerWeekday[weekday] === 'undefined') {
                    throw new Error('Invalid timer weekday');
                }
            }
            yield this.postMessage({
                type: this.getMessage('set_proprietary_timer'),
                timerType: type,
                timeOn,
                timeOff,
                weekdays,
            });
        });
    }
    unsetProprietaryTimer(type) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                yield this.postMessage({
                    type: this.getMessage('delete_proprietary_timer'),
                    timerType: type,
                });
            }
            catch (error) {
                // Use failover method if delete fails that is supported in older front-display versions
                // It can be removed in some front-applet najor version
                yield this.setProprietaryTimer(type, null, null, []);
            }
        });
    }
    getMessage(name) {
        return this.messagePrefix + '.' + name;
    }
}
exports.default = Power;
//# sourceMappingURL=Power.js.map