import IPostMessage from '../IPostMessage';
import INetworkInfo, { INetworkInterface, INetworkOptions, INetworkOptionsLegacy, NetworkInterface } from './INetworkInfo';
export default class Network {
    private messagePrefix;
    private postMessage;
    constructor(messagePrefix: string, postMessage: IPostMessage<any>);
    /** @deprecated use sos.management.network.listInterfaces() instead */
    getActiveInfo(): Promise<INetworkInfo>;
    listInterfaces(): Promise<INetworkInterface[]>;
    /** @deprecated use sos.management.network.setManual2() instead */
    setManual(options: INetworkOptionsLegacy): Promise<void>;
    /**
     * Manually configure a network interface
     * @param interfaceName can be retrieved from the list of interfaces returned by listInterfaces()
     * @param options
     */
    setManual(interfaceName: string, options: INetworkOptions): Promise<void>;
    /** @deprecated use sos.management.network.setDHCP2() instead */
    setDHCP(networkInterface: NetworkInterface): Promise<void>;
    /**
     * Configure a network interface to use DHCP
     * @param interfaceName can be retrieved from the list of interfaces returned by listInterfaces()
     */
    setDHCP(interfaceName: string): Promise<void>;
    disableInterface(interfaceName: string): Promise<void>;
    private getMessage;
}
