import IPostMessage from '../IPostMessage';
import IBatteryStatus from './IBatteryStatus';
import INetworkInfo from './INetworkInfo';
import Firmware from './Firmware';
import Audio from "./Audio";
import Screen from './Screen';
import RemoteControl from './RemoteControl';
import Time from './Time';
import App from './App';
import OS from './OS';
import Debug from './Debug';
import Package from './Package';
import Power from './Power';
import Network from './Network';
import Wifi from './Wifi';
import Security from './Security';
import Proxy from './Proxy';
import PeerRecovery from './PeerRecovery';
import OSD from '../OSD/OSD';
import AutoRecovery from './AutoRecovery';
export default class Management {
    private messagePrefix;
    private postMessage;
    static MESSAGE_PREFIX: string;
    readonly app: App;
    readonly os: OS;
    readonly audio: Audio;
    readonly debug: Debug;
    readonly firmware: Firmware;
    readonly package: Package;
    readonly power: Power;
    readonly remoteControl: RemoteControl;
    readonly screen: Screen;
    readonly time: Time;
    readonly network: Network;
    readonly wifi: Wifi;
    readonly security: Security;
    readonly proxy: Proxy;
    readonly autoRecovery: AutoRecovery;
    readonly peerRecovery: PeerRecovery;
    readonly osd: OSD;
    constructor(messagePrefix: string, postMessage: IPostMessage<any>);
    supports(capability: string): Promise<boolean>;
    getModel(): Promise<string>;
    getSerialNumber(): Promise<string>;
    /** @deprecated Use sos.management.network.getActiveInfo() instead */
    getNetworkInfo(): Promise<INetworkInfo>;
    getBatteryStatus(): Promise<IBatteryStatus>;
    getTemperature(): Promise<number>;
    getBrand(): Promise<string>;
    resetSettings(): Promise<void>;
    factoryReset(): Promise<void>;
    private getMessage;
    private getMessagePrefix;
}
