"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validatePeerRecoveryConfiguration = void 0;
const Validate_1 = require("../Validate/Validate");
const validatePeerRecoveryConfiguration = (configuration) => {
    const validation = Validate_1.default({ configuration }).setError(new Error('Invalid peer recovery configuration')).required();
    if (!configuration.enabled) {
        validation.object({ enabled: 'boolean', autoEnableTimeoutMs: '?number' });
    }
    else {
        validation.object({ enabled: 'boolean', urlLauncherAddress: 'string' });
    }
};
exports.validatePeerRecoveryConfiguration = validatePeerRecoveryConfiguration;
//# sourceMappingURL=IPeerRecovery.js.map