import IPostMessage from '../IPostMessage';
import { FirmwareType } from './FirmwareType';
export default class Firmware {
    private messagePrefix;
    private postMessage;
    constructor(messagePrefix: string, postMessage: IPostMessage<any>);
    /**
     * Platform users can install general firmware version directly with passing just version number.
     * Optionally, the baseUrl can be passed as argument to specify server where the firmware files are accessible.
     *
     * @param version of installing firmware
     * @param baseUrl server URL where fw files are located (default: https://2.signageos.io)
     */
    upgrade(version: string, baseUrl?: string): Promise<void>;
    /**
     * Alias for method with swapped arguments
     * @alias upgrade(version: string, baseUrl?: string)
     * @param baseUrl server URL where fw files are located
     * @param version of installing firmware
     */
    upgrade(baseUrl: string, version: string): Promise<void>;
    /**
     * Open users can upgrade fw passing FQN uri where the firmware main file is located.
     * This file type/extension differs for every platform. E.g.:
     * - SSSP: http://example.com/fw/T-0.0.0.msd
     * - Tizen: http://example.com/fw/T-0.0.0.bem
     * - Webos: http://example.com/fw/0.0.0.epk
     * - Brightsign: http://example.com/fw/hd2-0.0.0.bsfw
     * - Linux: http://example.com/fw/rpi-0.0.0.img.zip
     * - Android: http://example.com/fw/FB-00.0.0.zip
     * @param fwUri FQN uri where the firmware main file is located.
     */
    upgrade(fwUri: string): Promise<void>;
    getVersion(): Promise<string>;
    getType(): Promise<FirmwareType>;
    private getMessage;
}
