"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const Validate_1 = require("../Validate/Validate");
class Debug {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
    }
    enable() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.setDebug(true);
        });
    }
    disable() {
        return __awaiter(this, void 0, void 0, function* () {
            yield this.setDebug(false);
        });
    }
    isEnabled() {
        return __awaiter(this, void 0, void 0, function* () {
            const { isEnabled } = yield this.postMessage({
                type: this.getMessage('is_enabled'),
            });
            return isEnabled;
        });
    }
    setDebug(enabled) {
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ enabled }).required().boolean();
            yield this.postMessage({
                type: this.getMessage('set_debug'),
                enabled,
            });
        });
    }
    getMessage(name) {
        return this.messagePrefix + '.' + name;
    }
}
exports.default = Debug;
//# sourceMappingURL=Debug.js.map