"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const UpgradeHelper_1 = require("./helpers/UpgradeHelper");
class App {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
    }
    getType() {
        return __awaiter(this, void 0, void 0, function* () {
            const { applicationType } = yield this.postMessage({
                type: this.getMessage('get_application_type'),
            });
            return applicationType;
        });
    }
    getVersion() {
        return __awaiter(this, void 0, void 0, function* () {
            const { applicationVersion } = yield this.postMessage({
                type: this.getMessage('get_application_version'),
            });
            return applicationVersion;
        });
    }
    upgrade(arg1, arg2) {
        return __awaiter(this, void 0, void 0, function* () {
            const { baseUrl, version, directUri } = UpgradeHelper_1.parseUpgradeArguments(arg1, arg2);
            yield this.postMessage({
                type: this.getMessage('app_upgrade'),
                baseUrl,
                version,
                directUri,
            });
        });
    }
    getMessage(name) {
        return this.messagePrefix + '.' + name;
    }
}
exports.default = App;
//# sourceMappingURL=App.js.map