import IPostMessage from '../IPostMessage';
export default class App {
    private messagePrefix;
    private postMessage;
    constructor(messagePrefix: string, postMessage: IPostMessage<any>);
    getType(): Promise<string>;
    getVersion(): Promise<string>;
    /**
     * Platform users can install general application version directly with passing just version number.
     * Optionally, the baseUrl can be passed as argument to specify server where the application files are accessible.
     *
     * @param version of installing application
     * @param baseUrl server URL where app files are located (default: https://2.signageos.io)
     */
    upgrade(version: string, baseUrl?: string): Promise<void>;
    /**
     * Alias for method with swapped arguments
     * @alias upgrade(version: string, baseUrl?: string)
     * @param baseUrl server URL where app files are located
     * @param version of installing application
     */
    upgrade(baseUrl: string, version: string): Promise<void>;
    /**
     * Open users can upgrade app passing FQN uri where the application main file is located.
     * This file type/extension differs for every platform. E.g.:
     * - SSSP: http://example.com/apps/sssp_config.xml or http://example.com/apps/ApplicationName.zip
     * - Tizen: http://example.com/apps/sssp_config.xml or http://example.com/apps/ApplicationName.wgt
     * - Webos 1, 2: http://example.com/apps/ApplicationName.zip
     * - Webos 3+: http://example.com/apps/ApplicationName.ipk
     * - Brightsign: http://example.com/apps/ApplicationName.zip
     * - Linux: http://example.com/apps/ApplicationName.apk
     * - Android: http://example.com/apps/ApplicationName.apk
     * @param appUri FQN uri where the application main file is located.
     */
    upgrade(appUri: string): Promise<void>;
    private getMessage;
}
