"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
const Validate_1 = require("../Validate/Validate");
class Input {
    constructor(window, messagePrefix) {
        this.window = window;
        this.messagePrefix = messagePrefix;
        this.eventEmitter = new events_1.EventEmitter();
        this.window.addEventListener('keyup', (event) => this.dispatchEventToParent(event));
    }
    onKeyUp(listener) {
        Validate_1.default({ listener }).required().function();
        this.eventEmitter.addListener('keyup', listener);
    }
    handleMessageData(data) {
        switch (data.type) {
            case this.getMessage('keyup'):
                const keyupEvent = {
                    type: 'keyup',
                    keyCode: data.keyCode,
                    keyName: data.keyName,
                };
                this.eventEmitter.emit('keyup', keyupEvent);
                break;
            default:
        }
    }
    removeEventListeners() {
        this.eventEmitter.removeAllListeners();
    }
    dispatchEventToParent(event) {
        return __awaiter(this, void 0, void 0, function* () {
            this.window.parent.document.dispatchEvent(new KeyboardEvent('keyup', event));
        });
    }
    getMessage(name) {
        return this.messagePrefix + '.' + Input.MESSAGE_PREFIX + '.' + name;
    }
}
exports.default = Input;
Input.MESSAGE_PREFIX = 'input';
//# sourceMappingURL=Input.js.map