import IPostMessage from '../IPostMessage';
import Led from './Led/Led';
import SerialPort from './SerialPort';
import ISerialPortOptions from './ISerialPortOptions';
import ISerialPortDataMessage from './ISerialPortDataMessage';
import BarcodeScanner from './BarcodeScanner/BarcodeScanner';
import IBarcodeScannerDataMessage from './BarcodeScanner/IBarcodeScannerDataMessage';
export default class Hardware {
    private messagePrefix;
    private postMessage;
    static MESSAGE_PREFIX: string;
    readonly led: Led;
    barcodeScanner: BarcodeScanner;
    private eventEmitter;
    constructor(messagePrefix: string, postMessage: IPostMessage<any>);
    openSerialPort(options: ISerialPortOptions): Promise<SerialPort>;
    handleMessageData(data: ISerialPortDataMessage | IBarcodeScannerDataMessage): void;
    private getMessage;
    private getMessagePrefix;
}
