"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEFAULT_SCANNER_ID = void 0;
const events_1 = require("events");
exports.DEFAULT_SCANNER_ID = 0;
class BarcodeScanner {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
        this.eventEmitter = new events_1.EventEmitter();
    }
    /**
     * @experimental
     */
    getVersion() {
        return __awaiter(this, void 0, void 0, function* () {
            const { version } = yield this.postMessage({
                type: this.getMessage('get_version'),
            });
            return version;
        });
    }
    /**
     * @experimental
     */
    start(userOptions) {
        return __awaiter(this, void 0, void 0, function* () {
            const defaultOptions = { scannerId: exports.DEFAULT_SCANNER_ID, timeout: 10000, cancelPrevious: false };
            const _a = Object.assign(Object.assign({}, defaultOptions), userOptions), { scannerId } = _a, options = __rest(_a, ["scannerId"]);
            if (options.cancelPrevious) {
                this.eventEmitter.removeAllListeners(`scanner_id_${scannerId}.data`);
                this.eventEmitter.removeAllListeners(`scanner_id_${scannerId}.error`);
            }
            yield this.postMessage({
                type: this.getMessage('start'),
                scannerId,
                options,
            });
            const onData = (listener) => {
                this.eventEmitter.addListener(`scanner_id_${scannerId}.data`, listener);
            };
            const onError = (listener) => {
                this.eventEmitter.addListener(`scanner_id_${scannerId}.error`, listener);
            };
            const stop = () => __awaiter(this, void 0, void 0, function* () {
                yield this.postMessage({
                    type: this.getMessage('stop'),
                    scannerId,
                });
                this.eventEmitter.removeAllListeners(`scanner_id_${scannerId}.data`);
                this.eventEmitter.removeAllListeners(`scanner_id_${scannerId}.error`);
            });
            return { stop, onData, onError };
        });
    }
    handleMessageData(msg) {
        switch (msg.type) {
            case this.getMessage('data'):
                this.eventEmitter.emit(`scanner_id_${msg.scannerId}.data`, msg.data);
                break;
            case this.getMessage('error'):
                this.eventEmitter.emit(`scanner_id_${msg.scannerId}.error`, msg.data);
                break;
            default:
        }
    }
    getMessage(name) {
        return [this.messagePrefix, BarcodeScanner.MESSAGE_PREFIX, name].join('.');
    }
}
exports.default = BarcodeScanner;
BarcodeScanner.MESSAGE_PREFIX = 'barcode_scanner';
//# sourceMappingURL=BarcodeScanner.js.map