"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fontFaceGenerator = exports.generateFontUid = void 0;
const generateFontUid = (uid, format) => uid + '.' + format;
exports.generateFontUid = generateFontUid;
const fontFaceGenerator = (window, fontFaceProps) => {
    const fontFamily = `font-family: '${fontFaceProps.fontFamily}';`;
    const fontStretch = (fontFaceProps.fontStretch) ? `font-stretch: ${fontFaceProps.fontStretch};` : '';
    const fontStyle = (fontFaceProps.fontStyle) ? `font-style: ${fontFaceProps.fontStyle};` : '';
    const fontWeight = (fontFaceProps.fontWeight) ? `font-weight: ${fontFaceProps.fontWeight};` : '';
    const unicodeRange = (fontFaceProps.unicodeRange) ? `unicode-range: ${fontFaceProps.unicodeRange};` : '';
    let sources = [];
    let srcCompatMode = '';
    const setFormat = (format, uri) => {
        switch (format) {
            case 'woff':
                sources.push(`url('${uri}') format('woff')`);
                break;
            case 'woff2':
                sources.push(`url('${uri}') format('woff2')`);
                break;
            case 'ttf':
                sources.push(`url('${uri}') format('truetype')`);
                break;
            case 'svg':
                sources.push(`url('${uri}#svgFontName') format('svg')`);
                break;
            case 'eot':
                srcCompatMode = `src: url('${uri}');`;
                sources.push(`url('${uri}?#iefix') format('embedded-opentype')`);
                break;
            default:
                console.warn(`Not supported font format: ${format}`);
        }
    };
    const generateStyleElement = () => {
        const src = 'src: ' + sources.join(', ');
        const styleBody = `@font-face {${fontFamily}${fontStretch}${fontStyle}${fontWeight}${unicodeRange}${srcCompatMode}${src} }`;
        const styleComponent = window.document.createElement('style');
        styleComponent.innerHTML = styleBody;
        return styleComponent;
    };
    return {
        setFormat,
        generateStyleElement,
    };
};
exports.fontFaceGenerator = fontFaceGenerator;
//# sourceMappingURL=fontFaceGenerator.js.map