export interface IStorageUnit {
    type: string;
    capacity: number;
    freeSpace: number;
    usableSpace: number;
    removable: boolean;
}
export declare const VIStorageUnit: {
    type: string;
    capacity: string;
    freeSpace: string;
    usableSpace: string;
    removable: string;
};
export interface IFile {
    localUri: string;
    imageThumbnailUriTemplate?: string;
    videoThumbnailUriTemplate?: string;
    createdAt?: number;
    lastModifiedAt?: number;
    sizeBytes?: number;
    mimeType?: string;
}
export interface IVideoFile extends IFile {
    videoDurationMs?: number;
    videoResolution?: {
        width: number;
        height: number;
    };
    videoFramerate?: number;
    videoBitrate?: number;
    videoCodec?: string;
    audioBitrate?: number;
    audioCodec?: string;
}
export interface IHeaders {
    [key: string]: string;
}
export interface IFilePath {
    storageUnit: IStorageUnit;
    filePath: string;
}
export declare const VIFilePath: {
    storageUnit: {
        object: {
            type: string;
            capacity: string;
            freeSpace: string;
            usableSpace: string;
            removable: string;
        };
    };
    filePath: string;
};
export interface ICopyFileOptions {
    overwrite?: boolean;
}
export declare const VICopyFileOptions: {
    overwrite: string;
};
export interface IMoveFileOptions {
    overwrite?: boolean;
}
export declare const VIMoveFileOptions: {
    overwrite: string;
};
