import IPostMessage from '../IPostMessage';
import { IStorageUnit, IFilePath, IFile, IHeaders, ICopyFileOptions, IMoveFileOptions } from './types';
import StorageUnitsChangedMessage from './StorageUnitsChangedMessage';
export default class FileSystem {
    private messagePrefix;
    private postMessage;
    static MESSAGE_PREFIX: string;
    private eventEmitter;
    constructor(messagePrefix: string, postMessage: IPostMessage<any>);
    listStorageUnits(): Promise<IStorageUnit[]>;
    onStorageUnitsChanged(listener: () => void): void;
    removeStorageUnitsChangedListener(listener: () => void): void;
    removeAllListeners(): void;
    listFiles(directoryPath: IFilePath): Promise<IFilePath[]>;
    exists(filePath: IFilePath): Promise<boolean>;
    getFile(filePath: IFilePath): Promise<IFile | null>;
    writeFile(filePath: IFilePath, contents: string): Promise<void>;
    appendFile(filePath: IFilePath, contents: string): Promise<void>;
    readFile(filePath: IFilePath): Promise<string>;
    copyFile(sourceFilePath: IFilePath, destinationFilePath: IFilePath, options?: ICopyFileOptions): Promise<void>;
    moveFile(sourceFilePath: IFilePath, destinationFilePath: IFilePath, options?: IMoveFileOptions): Promise<void>;
    deleteFile(filePath: IFilePath, recursive: boolean): Promise<void>;
    downloadFile(filePath: IFilePath, sourceUri: string, headers?: IHeaders): Promise<void>;
    extractFile(archiveFilePath: IFilePath, destinationDirectoryPath: IFilePath, method: string): Promise<void>;
    createArchive(archiveFilePath: IFilePath, archiveEntries: IFilePath[]): Promise<void>;
    getFileChecksum(filePath: IFilePath, hashType: string): Promise<string>;
    createDirectory(directoryPath: IFilePath): Promise<void>;
    isDirectory(filePath: IFilePath): Promise<boolean>;
    link(sourceFilePath: IFilePath, destinationFilePath: IFilePath): Promise<void>;
    handleMessageData(data: StorageUnitsChangedMessage): void;
    private getMessage;
}
