"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const errorHelper_1 = require("./errorHelper");
class SosError extends Error {
    constructor({ message, code, suggestion, pathToDocs, type }) {
        super(message);
        this.name = type ? type : 'SosError';
        this.code = code;
        this.suggestion = suggestion;
        this.pathToDocs = pathToDocs;
        this.stack = errorHelper_1.getEnrichedStack({
            type: this.name,
            message,
            code,
            stackTrace: this.stack,
            suggestion,
            pathToDocs,
        });
    }
}
exports.default = SosError;
//# sourceMappingURL=SosError.js.map