import ErrorCodes from './ErrorCodes';
import ErrorSuggestions from './ErrorSuggestions';
export interface IBaseSosErrorParams {
    message: string;
    code: ErrorCodes;
    type?: string;
    suggestion?: ErrorSuggestions;
}
export interface IBaseSosErrorParamsWithDocs extends IBaseSosErrorParams {
    pathToDocs?: string;
}
export interface ISosErrorParams extends IBaseSosErrorParamsWithDocs {
    kind: 'sosError';
}
export default class SosError extends Error {
    code: ErrorCodes;
    suggestion?: ErrorSuggestions;
    pathToDocs?: string;
    constructor({ message, code, suggestion, pathToDocs, type }: ISosErrorParams);
}
