"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const Validate_1 = require("../Validate/Validate");
class Display {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
        this.version = null;
    }
    supports(capability) {
        return __awaiter(this, void 0, void 0, function* () {
            Validate_1.default({ capability }).string();
            const { supports } = yield this.postMessage({
                type: this.getMessage('supports'),
                capability,
            });
            return supports;
        });
    }
    getMessage(name) {
        return this.messagePrefix + '.' + Display.MESSAGE_PREFIX + '.' + name;
    }
}
Display.MESSAGE_PREFIX = 'display';
exports.default = Display;
//# sourceMappingURL=Display.js.map