"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const events_1 = require("events");
const AppletCommandError_1 = require("../Error/AppletCommandError");
const ErrorCodes_1 = require("../Error/ErrorCodes");
const ErrorSuggestions_1 = require("../Error/ErrorSuggestions");
const Validate_1 = require("../Validate/Validate");
class Command {
    constructor(messagePrefix, postMessage) {
        this.messagePrefix = messagePrefix;
        this.postMessage = postMessage;
        this.eventEmitter = new events_1.EventEmitter();
    }
    dispatch(command) {
        return __awaiter(this, void 0, void 0, function* () {
            this.checkTypeValidity(command.type);
            yield this.postMessage({
                type: this.getMessage("dispatch"),
                command,
            });
        });
    }
    onCommand(listener) {
        Validate_1.default({ listener }).required().function();
        this.eventEmitter.addListener('command', listener);
    }
    handleMessageData(data) {
        switch (data.type) {
            case this.getMessage('dispatch_to_applet'):
                const commandEvent = {
                    type: 'command',
                    command: data.command,
                };
                this.eventEmitter.emit('command', commandEvent);
                break;
            default:
        }
    }
    getMessage(name) {
        return this.messagePrefix + '.' + Command.MESSAGE_PREFIX + '.' + name;
    }
    checkTypeValidity(type) {
        const regex = /^[a-zA-Z0-9\.\-_]+$/g;
        Validate_1.default({ type }).setError(new AppletCommandError_1.default({
            kind: 'appletCommandError',
            message: 'Type contains invalid characters.',
            code: ErrorCodes_1.default.COMMAND_TYPE_NOT_VALID,
            suggestion: ErrorSuggestions_1.default.COMMAND_TYPE_NOT_VALID,
        })).required().string().matchRegExp(regex);
        Validate_1.default({ type }).setError(new AppletCommandError_1.default({
            kind: 'appletCommandError',
            message: 'Type is longer then 100 characters.',
            code: ErrorCodes_1.default.COMMAND_TYPE_IS_TOO_LONG,
        })).lengthMax(100);
    }
}
exports.default = Command;
Command.MESSAGE_PREFIX = 'command';
//# sourceMappingURL=Command.js.map