"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VIOpenLinkOptions = exports.VITheme = void 0;
exports.VITheme = {
    base: { '?string': ['light', 'dark'] },
    shape: { '?object': {
            cornerSize: '?number',
        },
    },
    colors: { '?object': {
            primary: '?string',
            background: '?string',
            control: '?string',
        },
    },
    widgets: { '?object': {
            editAddress: { '?object': {
                    colors: { '?object': {
                            background: '?string',
                            text: '?string',
                        },
                    },
                },
            },
            buttonClose: { '?object': {
                    colors: { '?object': {
                            background: '?string',
                            text: '?string',
                            icon: '?string',
                        },
                    },
                    icon: { '?string': ['none', 'exit_to_app', 'close', 'cancel'] },
                    text: '?string',
                },
            },
            progress: { '?object': {
                    color: '?string',
                },
            },
        },
    },
};
exports.VIOpenLinkOptions = {
    aclDomains: { '?array': 'string' },
    aclMode: { '?string': ['blacklist', 'whitelist'] },
    readOnlyAddressBar: '?boolean',
    idleTimeout: '?number',
    coordinates: { '?object': {
            x: 'number',
            y: 'number',
            width: 'number',
            height: 'number',
        },
    },
    theme: { '?object': exports.VITheme },
    headlessMode: '?boolean',
    clearData: '?boolean',
    canUserClose: '?boolean',
};
//# sourceMappingURL=IOpenLinkOptions.js.map