import { IDeprecatedOpenLinkOptions } from './IOpenLinkOptions';
import IOpenLinkOptions from './IOpenLinkOptions';
import { CloseEvent } from './events';
import { IBrowserMessage } from './messages';
import Exchange from '../Exchange/Exchange';
export default class Browser {
    private readonly exchange;
    private readonly events;
    constructor(exchange: Exchange<void>);
    open(uri: string, options?: IOpenLinkOptions): Promise<void>;
    close(): Promise<void>;
    /**
     * Find out when the browser is closed.
     * This can happen by an API call, by a user request or after a timeout.
     *
     * This doesn't fire between `open` calls or on subsequent `close` calls.
     *
     * @returns A callback which removes the listener.
     */
    onClose(listener: (event: CloseEvent) => void): () => void;
    handleMessageData(data: IBrowserMessage): void;
    /** @deprecated use sos.browser.open() instead */
    openLink(uri: string, options?: IDeprecatedOpenLinkOptions): Promise<void>;
}
