---
title:  Package
author: Krystof Woldrich
date:   24.4.2018
type:   js-management-api
tags:
- applet
- applet_api
- api
- js_management_api
description: "[Management JS API] Management API package allows you to install new packages."
---

# Package
Management API package allows you to install new packages.

## All methods

::: table-responsive
| Methods  | Description | Supported since |
| ------ | -------- | :-------------: |
| `install()` | Install additional packages to Android devices (eg. new WebView) | 3.0 |
:::


## install()
Method `install()` will install a certain package from the specified url.

::: table-responsive
|      Param     |Type          | Required | Value | Description                   |
| -------------- | --------------| :---------------: | ------ | ---------------------- |
| `baseUrl`     | String                 | <div class="red">Yes</div> |  `https://cdn.your-cms.com`   | URL where the package is available |
| `packageName`  | String                   | <div class="red">Yes</div> |  `io.signageosWebView.app.ota` | Name of the android package |
| `version`     | String                    | <div class="red">Yes</div> |  `2.4.0` | Package version |
| `build`     | String or null               | <div class="red">Yes</div> | `benq` or `philips`,... | If relevant for your device |
:::

### Javascript example
```javascript
await sos.management.package.install(
    'https://cdn.your-cms.com',
    'io.signageosWebView.app.ota',
    '2.4.0',
    'benq'
);
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/package-install/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">How to install package on device</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>
