---
title:  Audio
author: Miroslav Behina
date:   1.4.2018
type:   js-management-api
tags:
- applet
- applet_api
- api
- js_management_api
description: "[Management JS API] Management API audio allows you to check and set your devices current audio volume setting."
---

# Audio
Management API audio allows you to check and set your devices current audio volume setting.

## All methods

::: table-responsive
| Method  | Description | Supported since |
| ------ | ------ | :-------------: |
| `getVolume()` | Get current volume level | 2.0 |
| `setVolume()` | Set volume level | 2.0 |
:::

## getVolume()
Method `getVolume()` lets you check for current level of volume set on the device.

### Javascript example
```javascript
await sos.management.audio.getVolume(); // Returns number e.g. 39
```

## setVolume()
Method `setVolume()` lets you set level of volume on your device.

::: table-responsive
|      Param     |Type            | Required | Value | Description                   |
| -------------- | ----------------| :-------------: | -------- | -------------------- |
| `volume`     | Number            | <div class="red">Yes</div> |  `0` - `100`   | Volume level |
:::

### Javascript example
```javascript
await sos.management.audio.setVolume(90);
```
