---
title:  Screen
author: Miroslav Behina
date:   1.4.2018
type:   js-management-api
tags:
- applet
- applet_api
- api
- js_management_api
description: "[Management JS API] Management API screen allows for manipulation with screen resolution, orientation, content, set displays brightness, retrieve current brightness of your display and manipulate with the power mode. It enables you to turn display on, off and check whether the display is on/off."
---

# Screen
Management API screen allows for manipulation with screen resolution, orientation, content, set displays brightness, retrieve current brightness of your display and manipulate with the power mode. It enables you to turn display on, off and check whether the display is on/off.

::: alert alert--warning
This method turns on/off only display/backlight. It will **not** set any power-safe mode. We strongly recommend to
reboot any device once a day.
:::

::: alert alert--info
There is a specific behavior based on the device type you operate:
**On SoC displays** (e.g. Samsung Tizen, LG webOS, Android-based SoC displays from Sony, Vestel Philips,...)
- `powerOn()` and `powerOff()` are turning the display backlight and the panel off

**On external media players** (e.g. BrightSign, Windows PC, Android players, Raspberry Pi)
- `powerOn()` and `powerOff()` are turning off the video output (typically HDMI-out); the connected display backlight is not managed by this functionality and needs to be controlled via RS232 or another way.
:::


## All methods

::: table-responsive
| Method  | Description | Supported since |
| ------ | ------ | -------- | :-------------: |
| `resize()` | Set screen settings like resolution, orientation and video orientation | 3.0.0 |
| `getOrientation()` | Get screen orientation | 4.7.0 |
| `setBrightness()` | Set screen brightness | 3.0.0 |
| `getBrightness()` | Get current brightness value | 3.0.0 |
| `powerOn()` | Turn `ON` the display (only the display) | 3.0.0 |
| `powerOff()` | Turn `OFF` the display (only the display, except Android devices where it turns off the webview as well) | 3.0.0 |
| `isPoweredOn()` | Check the display status | 3.0.0 |
| `takeAndUploadScreenshot()` | Takes screenshot from the device and upload it to server | 3.0.0 |
:::


## resize()
Method `resize()` helps you manipulate with several aspects of your displays screen settings.

::: table-responsive
|      Param     |Type               | Required | Description                   |
| -------------- | -------------------| :----------: | -------------------- |
| `baseUrl`     | String               | <div class="red">Yes</div> | SSSP & Tizen devices  requires to install a orientation-specific Core App if you want to switch orientation to portrait or landscape. |
|^^|^^|^^| `https://cdn.your-cms.com/tizen/1.0.4` |
| `orientation`     | Orientation               | <div class="red">Yes</div> | Screen orientation  |
|^^|^^|^^| `PORTRAIT`, `LANDSCAPE`, `PORTRAIT_FLIPED`, `LANDSCAPE_FLIPPED`, `AUTO` |
| `resolution`     | Resolution                  | <div class="red">Yes</div> | Where it applies (mainly SSSP 2/3) |
|^^|^^|^^| `FULL_HD`, `HD_READY` |
| `currentVersion`     | String                  | <div class="red">Yes</div> |  Core App version |
|^^|^^|^^| `1.0.4` |
| `videoOrientation`     | VideoOrientation       | <div class="red">Yes</div> | If the video has different orientation than the HTML5 content |
|^^|^^|^^| `LANDSCAPE`, `PORTRAIT` |
:::

::: alert alert--info
For Tizen, you have to provide `baseUrl` which points to your server where you uploaded previously built Core App for Tizen with your buiult-in Applet. [Read more how to upload your Core Apps here.](https://docs.signageos.io/hc/en-us/articles/4405245195666).
:::

### Javascript example
```javascript
// for Tizen
await sos.management.screen.resize(
    "https://cdn.your-cms.com/tizen/1.0.4",
    "PORTRAIT",
    "FULL_READY",
    "1.0.4"
);

//for all other supported device
await sos.management.screen.resize(
    "",
    "PORTRAIT",
    "HD_READY",
    ""
);
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/resize/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">How to resize screen on device</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

## getOrientation()
Method `getOrientation()` lets you check current orientation of the screen. Possible values are listed in the table above.

### Javascript example
```javascript
await sos.management.screen.getOrientation();
```

## setBrightness()
Function `setBrightness()` lets you control the power of brightness emmited by your device and even set different brightness during the day.

::: table-responsive
|      Param     |Type                  | Required | Description                   |
| -------------- | ---------------------| :--------: | --------------------- |
| `timeFrom1`     | String                | <div class="red">Yes</div> | Day time since `brightness1` value will be applied (eg. 06:00, 24hour values) |
|^^|^^|^^| Example: `00:00` - `23:59` |
| `brightness1`     | Number               | <div class="red">Yes</div> | Brightness level `0-100`  |
|^^|^^|^^| Example: `0` - `100` |
| `timeFrom2`     | String                 | <div class="red">Yes</div> | Day time since `brightness2` value will be applied (eg. 22:00, 24hour values) |
|^^|^^|^^| Example: `00:00` - `23:59` |
| `brightness2`     | Number                | <div class="red">Yes</div> | Brightness level `0-100` |
|^^|^^|^^| Example: `0` - `100` |
:::

### Javascript example
```javascript
await sos.management.screen.setBrightness(
    '00:00',
    '10',
    '17:00',
    '30'
);
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/brightness/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">How change brightness on device</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

## getBrightness()
Method `getBrightness()` lets you check the power of brightness emitted by your device.

### Javascript example
```javascript
await sos.management.screen.getBrightness();
```

### Example of response
```json
{
	"timeFrom1": "06:00:00",
	"brightness1": 80,
	"timeFrom2": "22:00:00",
	"brightness2": 40
}
```

## powerOn()
Method `powerOn()` turns on the targeted display.

```javascript
await sos.management.screen.powerOn(); // Returns void
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/display/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Management Display</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

## powerOff()
Method `powerOff()` turns off the targeted display.

::: alert alert--warning
On Android devices, `powerOff()` also shuts down the webview and the Applet. It's default Android behavior that cannot be changed. Once the Applet is off, you cannot call `powerOn()` to resume the playback.

To manage the display On/Off state, use [REST API Power Actions](https://api.docs.signageos.io/#138035f6-af92-4345-8eaa-9c7f1ed0efd3) instead.
:::

```javascript
await sos.management.screen.powerOff(); // Returns void
```

## isPoweredOn() 
Method `isPoweredOn()` lets you check whether the display is turned on or off.

```javascript
await sos.management.screen.isPoweredOn(); // Returns boolean
```

## takeAndUploadScreenshot()
Method `takeAndUploadScreenshot()` will upload a screenshot directly to the device.

::: table-responsive
|      Param     |Type                           | Required | Description                   |
| -------------- | ----------------------------- | :------: | ---------------------- |
| `uploadBaseUrl`  | String                     | <div class="red">Yes</div>| Location of your Upload server for screenshots |
|^^|^^|^^| Example: `https://upload-screenshot.your-cms.com` |
:::

### Javascript example
```javascript
await sos.management.screen.takeAndUploadScreenshot(
    'https://upload-screenshot.your-cms.com'
);
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/screenshot-upload/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Management Screenshot Upload</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

<br>

::: alert alert--warning
Open users (who is using screenshot capturing on device using JS API) have to run their own server for uploading screenshots. It differs for every platform! So it's not easy to achieve the unified output (screenshots url upload).  
There are 2 options how to manage this:  
   
**Option 1.**   
Specify the signageOS upload URL which is available for every our partner. However it's not granted SLA on this server for open users. The URL is https://upload.signageos.io  

Cons:
- internet required (no local instances in local networks).
- SLA is not granted, dependency on signageos infrastructure for open users.  

Pros:
- it's easy to use
- zero configuration, zero programming work needed  

**Option 2.**  
There is available standalone server for uploading screenshots with all available methods of uploading for every platform (Tizen, Webos, Linux etc.). It's created in node.js and open users have to host it on the own infrastructure.  

Cons:  
- The screenshot traffic needed to be paid/covered.
- The upload server needs to be configured and managed by our customer who is running it.  

Pros:
- it's signageOS independent
- it can be run in local, close networks without internet access (or firewalls)
- zero programming work and cost needed  

**The standalone server is available on request via the support ticketing system: [create new support ticket](https://docs.signageos.io/tickets/create)**  
:::
