---
title:  Power
author: Krystof Woldrich
date:   24.4.2018
type:   js-management-api
tags:
- applet
- applet_api
- api
- js_management_api
description: "[Management JS API] POWER allows you to reboot the system, restart the application and set timer."
---

# Power
Management API power allows you to reboot the system, restart the application and set timer.

## All methods

::: table-responsive
| Methods  | Description | Supported since |
| ------ | ------ | ------------- |
| `systemReboot()` | Safely reboot device | 3.0.0 |
| `appRestart()` | Restart Core App | 3.0.0 |
| `setTimer()` | Create/Set Timer - when the device turns on and off based on the days in a week | 3.0.0 |
| `unsetTimer()` | Remove Timer - when the device turns on and off based on the days in a week | 4.0.0 |
| `getTimers()` | List All Timers - when the device turns on and off based on the days in a week | 4.0.0 |
| `setProprietaryTimer()` | Create/Set Proprietary Timer - when the device turns on and off based on the days in a week | 5.10.0 |
| `unsetProprietaryTimer()` | Remove Proprietary Timer - when the device turns on and off based on the days in a week | 5.10.0 |
| `getProprietaryTimers()` | List All Proprietary Timers - when the device turns on and off based on the days in a week | 5.10.0 |
:::

## systemReboot()
Method `systemReboot()` will reboot a targeted device.

```javascript
await sos.management.power.systemReboot(); // Returns void
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/system-reboot/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Management System Reboot</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

## appRestart()
Method `appRestart()` will restart the application on a targeted device.

```javascript
await sos.management.power.appRestart(); // Returns void
```

## setTimer() 
Method `setTimer()` will set the time of the timer.

::: table-responsive
|      Param     | Type                   | Required |Description                   |
| -------------- | ----------------------| :-------: | ---------------------------- |
| `type`     | TimerType                 | <div class="red">Yes</div> | 7 slots for your timers |
|^^|^^|^^| `TIMER_1`, `TIMER_2`, `TIMER_3`, `TIMER_4`, `TIMER_5`, `TIMER_6`, `TIMER_7` |
| `timeOn`     | String or null                  | <div class="red">Yes</div> | When the device/display should be turned on  |
|^^|^^|^^| `00:00:00` - `23:59:00` |
| `timeOff`     | String or null               | <div class="red">Yes</div> | When the device/display should be turned off |
|^^|^^|^^| `00:00:00` - `23:59:00` |
| `weekdays`     | TimerWeekday[]                  | <div class="red">Yes</div> | Weekdays when timer is applied |
|^^|^^|^^| `sun`, `mon`, `tue`, `wed`, `thu`, `fri`, `sat` |
| `volume`     | Number                   | <div class="red">Yes</div> | Volume level set when the device/display is turned on |
|^^|^^|^^| `0` - `100` |
:::

### Javascript example
```javascript
await sos.management.power.setTimer("TIMER_1", "09:00:00", "23:00:05", ["mon"], 10);
```

## unsetTimer() 
Method `unsetTimer()` will remove the timer.

::: table-responsive
|      Param     | Type                   | Required |Description                   |
| -------------- | ----------------------| :-------: | ---------------------------- |
| `type`     | TimerType                 | <div class="red">Yes</div> | 7 slots for your timers |
|^^|^^|^^| `TIMER_1`, `TIMER_2`, `TIMER_3`, `TIMER_4`, `TIMER_5`, `TIMER_6`, `TIMER_7` |
:::

### Javascript example
```javascript
await sos.management.power.unsetTimer("TIMER_1");
```

## getTimers() 
Method `getTimer()` will return all currently set timers.

### Javascript example
```javascript
const timers = await sos.management.power.getTimers();
```

### Example of response
```json
[
    {
        "type": "TIMER_1",
        "timeOn": "05:00:00",
        "timeOff": "15:00:00",
        "weekdays": ["mon", "sun"],
        "volume": 29
    },
    {
        "type": "TIMER_3",
        "timeOn": "08:00:00",
        "timeOff": "19:00:00",
        "weekdays": ["fri", "sat"],
        "volume": 85
    },
]
```

## setProprietaryTimer()
Method `setProprietaryTimer()` will set the time of the proprietary timer.

::: table-responsive
|      Param     | Type                   | Required |Description                   |
| -------------- | ----------------------| :-------: | ---------------------------- |
| `type`     | TimerType                 | <div class="red">Yes</div> | Slots for your timers in format `TIMER_${number}` |
|^^|^^|^^| `TIMER_1`, `TIMER_2`, `TIMER_3`, `TIMER_4`, `TIMER_5`, `TIMER_6`, `TIMER_XX` |
| `timeOn`     | String or null                  | <div class="red">Yes</div> | When the display/screen should be turned on  |
|^^|^^|^^| `00:00:00` - `23:59:00` |
| `timeOff`     | String or null               | <div class="red">Yes</div> | When the display/screen should be turned off |
|^^|^^|^^| `00:00:00` - `23:59:00` |
| `weekdays`     | TimerWeekday[]                  | <div class="red">Yes</div> | Weekdays when timer is applied |
|^^|^^|^^| `sun`, `mon`, `tue`, `wed`, `thu`, `fri`, `sat` |
:::

### Javascript example
```javascript
await sos.management.power.setProprietaryTimer("TIMER_105", "09:00:00", "23:00:05", ["mon"]);
```

## unsetProprietaryTimer()
Method `unsetProprietaryTimer()` will remove the proprietary timer.

::: table-responsive
|      Param     | Type                   | Required |Description                   |
| -------------- | ----------------------| :-------: | ---------------------------- |
| `type`     | TimerType                 | <div class="red">Yes</div> | Slots for your timers in format `TIMER_${number}` |
|^^|^^|^^| `TIMER_1`, `TIMER_2`, `TIMER_3`, `TIMER_4`, `TIMER_5`, `TIMER_6`, `TIMER_XX` |
:::

### Javascript example
```javascript
await sos.management.power.unsetProprietaryTimer("TIMER_105");
```

## getProprietaryTimers()
Method `getProprietaryTimers()` will return all currently set proprietary timers.

### Javascript example
```javascript
const timers = await sos.management.power.getProprietaryTimers();
```

### Example of response
```json
[
    {
        "type": "TIMER_1",
        "timeOn": "05:00:00",
        "timeOff": "15:00:00",
        "weekdays": ["mon", "sun"]
    },
    {
        "type": "TIMER_105",
        "timeOn": "08:00:00",
        "timeOff": "19:00:00",
        "weekdays": ["fri", "sat"]
    },
]
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/timer/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">How to use timer in Applet</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>
