---
title:  OS
author: Michael Zabka
date:   1.4.2018
type:   js-management-api
tags:
- applet
- applet_api
- api
- js_management_api
description: "[Management JS API] OS management API allows you to manage information of operating system on your current device."
---

# OS
OS management API allows you to manage information of operating system on your current device.

## All methods

::: table-responsive
| Method  | Description | Supported since |
| ------ | ------ | ------------- |
| `getInfo()` | Get current OS version | 5.0 |
| `getCpuUsage()` | Get current CPU usage | 5.4 |
| `getMemoryUsage()` | Get current RAM usage | 5.4 |
:::

## getInfo()
Method `getInfo()` will specify info about device like a what current version of is is installed on a device.

Major version of current operating system. It's usually 1 or 2 digits including or excluding dot notation.

**Examples:**

- Windows -> 7, 8, 10, 11
- WebOS -> 3, 3.2, 4, 4.1, 6
- Tizen -> 2.4, 3, 4, 5, 6.5

### Javascript example
```javascript
sos.management.os.getInfo().then((info) => {
    console.log(info); // Returns Object e.g. { version: 3 }
});
```

## getCpuUsage()
Method `getCpuUsage()` returns current CPU usage as number from 0 to 100.

### Javascript example
```javascript
sos.management.os.getCpuUsage().then((usage) => {
    console.log(usage); // Returns number e.g. 50 as 50 %
});
```

## getMemoryUsage()
Method `getMemoryUsage()` returns total memory amount in bytes, currently used memory and remaining free memory.

### Javascript example
```javascript
sos.management.os.getMemoryUsage().then((usage) => {
    console.log(usage); // Returns number e.g. { total: 2048, used: 1024, free 1024 }
});
```
