---
title:  Firmware
author: Miroslav Behina
date:   1.4.2018
type:   js-management-api
tags:
- applet
- applet_api
- api
- js_management_api
description: "[Management JS API] Firmware management API allows you to remotely upgrade firmware version and check version on your current device."
---

# Firmware
Firmware management API allows you to remotely upgrade firmware version and check version on your current device.

## All methods

::: table-responsive
| Method  | Description | Supported since |
| ------ | ------ | ------------- |
| `upgrade()` | Allows you to upgrade device FW | 3.0 |
| `getVersion()` | Get current FW version | 3.0 |
:::

## upgrade()
Method `upgrade()` will upgrade current firmware version to a specified one.

::: table-responsive
|      Param     |Type                  | Required | Description                   |
| -------------- | ----------------------| :-------: | -------------------- |
| `baseUrl`     | string                 | <div class="red">Yes</div> | Location of the FW package for specific device |
|^^|^^|^^| `https://cdn.your-cms.com/tizen/pmf/fw/2080_4.bem` |
| `version`     | string                 | <div class="yellow">No</div> | FW version |
|^^|^^|^^| `T-HKMLAKUC-2080.4` |
| `(progress: number)` | callback | <div class="yellow">No</div> | FW progress upgrade |
:::

### Javascript example
```javascript
await sos.management.firmware.upgrade(
	'https://cdn.your-cms.com/tizen/pmf/fw/2080_4.bem',
	'T-HKMLAKUC-2080.4',
	(progress: number) => {
	    console.log(progress + "%");
    }
);

await sos.management.firmware.upgrade('https://cdn.your-cms.com/tizen/pmf/fw/2080_4.bem');
```

::: alert alert--warning
Always check if your absolute firmware URL ends with firmware file.
Example: `https://cnd.your-cms.com/brightsign/fw/brightsign-update.bsfw`
:::

::: alert alert--info
For BrightSign firmware upgrade please ensure that you have txt file with SHA1 hash of that firmware file.
- Firmware file path: `https://cnd.your-cms.com/brightsign/fw/brightsign-update.bsfw`
- SHA1 txt file: `https://cnd.your-cms.com/brightsign/fw/brightsign-update.bsfw.sha1.txt`
:::

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/firmware/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">How to upgrade firmware</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

## getVersion()
Method `getVersion()` will specify what current version of firmware is installed on a device.

### Javascript example
```javascript
sos.management.firmware.getVersion().then((version) => { 
    console.log(version); // Returns String e.g. T-HKMLAKUC-2020.5
});
```

## getType()
Returns a string identifier that, when combined with firmware version, can be used to identify a correct firmware image to install on the current device.

::: table-responsive
|      Type     | Description                            |
| ------------- | -------------------------------------- |
| `rpi`         | any Raspberry Pi 3 or Compute Module 3 |
| `rpi4`        | any Raspberry Pi 4 or Compute Module 4 |
| `benq-`       | any Benq display |
| `philips-`    | any Philips display |
| `sharp-`      | any Sharp display |
| `elo-`        | any Elo display |
:::

### Javascript example
```javascript
const type = await sos.management.firmware.getType(); 
console.log(type); // e.g. rpi4
```
