---
title:  Proxy
author: Krystof Woldrich
date:   16.6.2022
type:   js-management-api
tags:
- applet
- applet_api
- api
- js_management_api
- proxy
description: "[Management JS API] Proxy management API enables you to manage currently connected proxy on your device."
---

# Proxy
Proxy management API enables you to manage currently connected proxy on your device.

## All methods

::: table-responsive
| Method             | Description                         | Supported since |
| ------------------ | ----------------------------------- | --------------- |
| `isEnabled()`      | Get proxy setting state             | 5.4             |
| `setManual()`      | Set proxy using provides parameters | 5.4             |
| `disable()`        | Disable proxy                       | 5.4             |
| `getConnectedTo()` | Get connected proxy uri             | 5.4             |
:::

## isEnabled()
Method `isEnabled()` returns the current state of a proxy on your device.

### Javascript example
```javascript
sos.management.proxy.isEnabled().then((isEnabled) => {
    console.log(isEnabled);
});
```

## setManual()
Method `setManual()` lets you set proxy settings on your device.

::: table-responsive
| Param          | Type   | Required                   | Value             | Description              |
| -------------- | -------| :------------------------: | ----------------- | ------------------------ |
| `uri`          | String | <div class="red">Yes</div> |  `178.62.193.192` | URI of the proxy server  |
| `port`         | Number | <div class="red">No</div>  |  `0` - `65353`    | Port number              |
| `username`     | String | <div class="red">No</div>  |  `johndoe`        | Username                 |
| `password`     | String | <div class="red">No</div>  |  `superpass`      | Password                 |
:::

### Javascript example
```javascript
sos.management.proxy.setManual(
	'178.62.193.192',
	1080,
	'username',
	'password'
).then(() => {
    console.log('Proxy successfully set.');
});
```

## disable()
Method `disable()` lets you disable current active proxy setting on your device.

### Javascript example
```javascript
sos.management.proxy.disable().then(() => {
    console.log('Proxy successfully disabled.');
});
```

## getConnectedTo()
Method `getConnectedTo()` returns the current connected proxy server uri on your device.

### Javascript example
```javascript
sos.management.proxy.getConnectedTo().then((uri) => {
    console.log(uri); //178.62.193.192
});
```


