---
title:  Security
author: Michael Zabka
date:   20.5.2020
type:   js-management-api
tags:
- applet
- applet_api
- api
- js_management_api
- security
description: "[Management JS API] Security management API allows you to manually set PIN code interfaces or get current PIN code."
---

# Security
Security management API allows you to manually set PIN code interfaces or get current PIN code.

## All methods

::: table-responsive
| Methods  | Description | Supported since |
| ------ | -------- | :-------------: |
| `getPinCode()` | Get PIN code, 4 digits number string | 4.1 |
| `setPinCode()` | Set PIN code, 4 digits number string | 4.1 |
| `generateRandomPinCode()` | Generate 4 digits number string and set it as PIN code | 4.1 |
:::

## getPinCode()
Method `getPinCode()` will returns current PIN code, 4 digits number string.

```javascript
await sos.management.security.getPinCode(); // Returns e.g. "1234"
```

## setPinCode()
Method `setPinCode()` will set the current PIN code, 4 digits number string.
PIN code `0000` is not allowed according to the default PIN after boot when the device is not connected to the internet!

::: table-responsive
| Param    | Type   | Required | Description                                                                                              |
| -------- | ------ | :----------: | ---------------------------------------------------------------------------------------------- |
| `pinCode`     | String | <div class="red">Yes</div> | Set new PIN code |
:::

### Javascript example
```javascript
await sos.management.security.setPinCode("9999");
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/security-pin-code/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Management Security PIN code</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>


## generateRandomPinCode()
Method `generateRandomPinCode()` will generate random 4 digits number string and set it as current PIN code.

### Javascript example
```javascript
await sos.management.security.generateRandomPinCode(); // Generate new random PIN code
const newPinCode = await sos.management.security.getPinCode(); // Get PIN code as string
console.log(newPinCode);
```

## Errors
Although we are doing our best, following errors may occur when working with the Applet Resources.

::: table-responsive
| Code | Type | Message |
| ---- | ---- | ------- |
| 41701 | AppletSecurityError | Invalid PIN code (has to be 4 digits string) |
| 41702 | AppletSecurityError | Not allowed PIN code 0000, use another pin code |
| 41703 | AppletSecurityError | Get PIN code failed because was not set yet. Try to get PIN code later or set the PIN code using `setPinCode` method first. |
:::
