---
title:  Network
author: Miroslav Behina
date:   1.4.2018
type:   js-management-api
tags:
- applet
- applet_api
- api
- js_management_api
- network
description: "[Management JS API] Network management API allows you to manually set network interfaces or set back DHCP and current active network info."
---

# Network
Network management API allows you to manually set network interfaces or set back DHCP and current active network info.

## All methods
::: table-responsive
| Method  | Description | Supported since |
| ------ | -------- | :-------------: |
| `getActiveInfo()` | Information about network interfaces, IP addesses and MAC addresses (**DEPRECATED**) | 4.0 |
| `listInterfaces()` | Information about network interfaces | 4.9 |
| `setManual()` | Allows you to set network settings manually | 4.0 |
| `setDHCP()` | Allows you to set network settings automatically from DHCP | 4.0 |
| `disableInterface()` | Disables a network interface | 4.13 |
:::

## getActiveInfo()
Method `getActiveInfo()` will display information about connected network.

::: alert alert--warning
This method is deprecated. Use `listInterfaces()` instead.
:::

### Javascript example
```javascript
await sos.management.network.getActiveInfo();
```

### Example of response
```json
{
	"activeInterface": "ethernet",
	"dns": [
		"192.168.1.1",
		"1.1.1.1"
	],
	"gateway": "192.168.1.1",
	"localAddress": "192.168.1.137",
	"ethernetMacAddress": "b8:27:eb:25:8f:63",
	"wifiMacAddress": "b8:27:eb:25:8f:63",
	"netmask": "255.255.255.0"
}
```

Wifi connection strength is described as percentage in range from 0 to 100, linearly converted from dBm -90 to -30 respectively based on platform.

```json
{
	"activeInterface": "wifi",
	"dns": [
		"192.168.1.1",
		"1.1.1.1"
	],
	"gateway": "192.168.1.1",
	"localAddress": "192.168.1.137",
	"ethernetMacAddress": "b8:27:eb:25:8f:63",
	"wifiMacAddress": "b8:27:eb:25:8f:63",
	"netmask": "255.255.255.0",
    "wifiSsid": "hotel",
    "wifiStrength": "87"
}
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/network/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Getting network data from device</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

## listInterfaces()
Returns list of all network interfaces, and their information like MAC address, IP address, etc.

### Javascript example
```javascript
const interfaces = await sos.management.network.listInterfaces();
```

### Example of response

Wifi connection strength is described as percentage in range from 0 to 100, linearly converted from dBm -90 to -30 respectively based on platform.

```json
[
  {
    "type": "ethernet",
    "name": "eth0",
    "macAddress": "b8:27:eb:25:8f:63",
    "localAddress": "192.168.1.137",
    "gateway": "192.168.1.1",
    "netmask": "255.255.255.0",
    "dns": [
      "192.168.1.1",
      "1.1.1.1"
    ]
  },
  {
    "type": "wifi",
    "name": "wlan0",
    "macAddress": "b8:27:eb:25:8f:63",
    "localAddress": "192.168.1.138",
    "gateway": "192.168.1.1",
    "netmask": "255.255.255.0",
    "dns": [
      "192.168.1.1",
      "1.1.1.1"
    ],
    "wifiSsid": "hotel",
    "wifiStrength": "87"
  }
]
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/network/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Getting network interfaces from device</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

## setManual()
Manually configures a network interface.
If the interface is disabled, it will be enabled.

::: alert alert--warning
Wi-Fi interface can be configured with this method but it has to be first enabled via the [Wi-Fi API](/api/js/management/11-js-management-network).
:::

### Object properties

#### New way
| Name | Type | Required | Description |
| ---- | ---- | :------: | ------ |
| `interfaceName` | String | <div class="red">Yes</div> | Network interface name, can be retrieved from `listInterfaces()` |
| `options.localAddress` | String | <div class="red">Yes</div> | Network local address |
| `options.gateway` | String | <div class="red">Yes</div> | Network gateway |
| `options.netmask` | String | <div class="red">Yes</div> | Network netmask |
| `options.dns` | Array | <div class="red">Yes</div> | Array of additionally DNSs |

#### Old way (deprecated)
| Name | Type | Required | Description |
| ---- | ---- | :------: | ------ |
| `interface` | String | <div class="red">Yes</div> | Network type interface, can be only `ethernet` or `wifi` |
| `localAddress` | String | <div class="red">Yes</div> | Network local address |
| `gateway` | String | <div class="red">Yes</div> | Network gateway |
| `netmask` | String | <div class="red">Yes</div> | Network netmask |
| `dns` | Array | <div class="red">Yes</div> | Array of additionally DNSs |

### Javascript example
```javascript
// new way
await sos.management.network.setManual('eth0', {
	localAddress: '192.168.1.133',
	gateway: '192.168.1.1',
	netmask: '255.255.255.0',
	dns: ['8.8.8.8', '192.168.1.1'],
});

// old way (deprecated)
await sos.management.network.setManual({
	interface: 'ethernet',
	localAddress: '192.168.1.133',
	gateway: '192.168.1.1',
	netmask: '255.255.255.0',
	dns: ['8.8.8.8', '192.168.1.1'],
});
```

## setDHCP() 
Configures a network interface to use DHCP to get an IP address asigned from the network.
If the interface is disabled, it will be enabled.

::: alert alert--warning
Wi-Fi interface can be configured with this method but it has to be first enabled via the [Wi-Fi API](/api/js/management/11-js-management-network).
:::

### Object properties

#### New way
| Name | Type | Required | Description |
| ---- | ---- | :------: | ------ |
| `interfaceName` | String | <div class="red">Yes</div> | Network interface name, can be retrieved from `listInterfaces()` |

#### Old way (deprecated)
| Name | Type | Required | Description |
| ---- | ---- | :------: | ------ |
| `networkInterface` | String | <div class="red">Yes</div> | Network type interface, can be only `ethernet` or `wifi` |

### Javascript example
```javascript
// new way
await sos.management.network.setDHCP('eth0');

// old way (deprecated)
await sos.management.network.setDHCP('ethernet');
```

## disableInterface()
Disables a network interface

::: table-responsive
| Param           | Type   | Required                   | Description                                          |
| --------------- | ------ | :------------------------: | ---------------------------------------------------- |
| `interfaceName` | String | <div class="red">Yes</div> | Name of the network interface, that will be disabled |
:::

### Javascript example
```javascript
await sos.management.wifi.disableInterface("eth0");
```

::: alert alert--info
A disabled network interface can be re-enabled simply by calling either `setDHCP()` or `setManual()`.
:::

::: alert alert--warning
Don't use this method to disable Wi-Fi.
Use [Wi-Fi API](/api/js/management/11-js-management-network) to enable/disable Wi-Fi.
:::
