---
title:  App
author: Krystof Woldrich
date:   24.4.2018
type:   js-management-api
tags:
- applet
- applet_api
- api
- js_management_api
description: "[Management JS API] Management API app lets you check application type and upgrade the application."
---

# App

Management API app lets you check application type and upgrade the application.

## All methods
::: table-responsive
| Method | Description | Supported since |
| ------ | -------- | ------------- |
| `getType()` | Information about the platform your application is running on (eg. Tizen) | |
| `getVersion()` | Information about current version of your application is running on the device (eg. 2.0.5) | |
| `upgrade()` | Upgrade/Downgrade the Core App  | |
:::

## getType() 
Method `getType()` returns the display type of application on the device.

```javascript
await sos.management.app.getType(); // Returns ex. sssp, android
```

**Returns one of the following types:**  
- `android`
- `brightsign`
- `default` (Emulator)
- `linux` (Raspberry Pi)
- `sssp`
- `tizen`
- `webos`
- `windows`

::: alert alert--info
If you need to get specific Android brand or Raspberry Pi model, use the [Firmware API](api/js/management/latest/2-js-management-firmware) `getType()`.
:::

## getVersion()
Method `getVersion()` returns the version of Core App application on the device.

*This API is only available for Applets deployed via Timing from Box or REST API.*

```javascript
await sos.management.app.getVersion(); // Returns ex. 2.0.0
```

## upgrade()
Method `upgrade()` will upgrade the [Core App](https://docs.signageos.io/hc/en-us/articles/4405381466898) on the device.


### A) Upgrading signageOS Core App
To upgrade to signageOS Core App, use the following parameters:

::: table-responsive
|      Param     |Type                           | Value |Description                   |
| -------------- | ----------------------------- | ------- | --------------------- |
| `baseUrl`     | String                        | `https://cdn.your-cms.com/tizen/`| Location of the new version of the Core App |
| `version`     | String                        |  `x.x.x` | Core App version |
:::

<div class="row d-flex align-content-stretch force-padding-10">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" href="/changelogs">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                   <i class="fas fa-sticky-note svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">List of our latest core app versions</h3>
                <div class="wide-box__description">signageOS Documentation</div>
            </div>
            </div>
        </a>
    </div>
</div>

### Javascript example
```javascript
await sos.management.app.upgrade('https://example.com/signageos-core-app.zip', '2.0.0');
```

<br>

### B) Upgrading Open Core App with built-in Applet
If you are [building your own Core App](https://docs.signageos.io/hc/en-us/articles/4405245195666) with the built-in Applet, use only one parameter `absolutePathUrl`.

The `absolutePathUrl` should point to the application file, e.g. `https://cdn.your-cms.com/rpi/linux_202006100815_1.0.1_779c303408.zip`.

::: table-responsive
|      Param     |Type                           | Value |Description                   |
| -------------- | ----------------------------- | ------- | --------------------- |
| `absolutePathUrl`| String     | `https://cdn.your-cms.com/rpi/linux_xxx.zip`| Location of the new version of the Open Core App with built-in Applet |
:::

### Javascript example
```javascript
await sos.management.app.upgrade('https://cdn.your-cms.com/rpi/linux_xxx.zip');
```

<br>

Because each of the platforms (Tizen, webOS, BrightSign, etc.) are different, use the following table to define correct `absolutePathUrl`:

::: table-responsive
| Platform | absolutePathUrl | Note |
| -------- | --------------- | ---- |
| Tizen | `https://cdn.your-cms.com/core-apps/landscape` <br/> `https://cdn.your-cms.com/core-apps/portrait` | |
| SSSP | `https://cdn.your-cms.com/core-apps/landscape_full-hd` <br/> `https://cdn.your-cms.com/core-apps/portrait_full-hd` | |
| webOS | `https://cdn.your-cms.com/core-apps/com.lg.app.signage_latest.ipk` <br/> `https://cdn.your-cms.com/core-apps/com.lg.app.signage_latest.zip` |  `.zip` is for old webOS 1.0 and 2.0 only |
| Android | `https://cdn.your-cms.com/core-apps/io.signageos.open_3.1.0.android.apk` | If you are building for specific version of Android (e.g. Benq) you will have a BenQ specific apk|
| BrightSign | `https://cdn.your-cms.com/core-apps/display-brightsign.zip` | |
| NEC / RPi | `https://cdn.your-cms.com/core-apps/linux_202006100815_1.0.1_779c303408.zip` | |
:::
