---
title:  Management
author: Miroslav Behina
date:   1.4.2018
type:   js-management-api
tags:
- applet
- applet_api
- api
- js_management_api
description: "[Management JS API] To make the management of devices more viable and open there is a management API prepared. Through this API things like device firmware, battery status, brightness, network information, remote control, power, time or volume can be monitored."
---

# Management

To make the management of devices more viable and open there is a management API prepared. Through this API things like device firmware, battery status, brightness, network information, remote control, power, time or volume can be monitored.

## All methods
::: table-responsive
| Method  | Description | Supported since |
| ------ | -------- | :------------: |
| `supports()` | Enum of supported features | 2.0.0 |
| `getModel()` | Information about device model | 2.0.0 |
| `getSerialNumber()` | Information about device serial number | 2.1.0 |
| `getBatteryStatus()` | Information about the battery level and battery charging status | 2.1.0 |
| `getNetworkInfo()` | Information about network connections, IPs and DNS | 4.0.0 |
| `getTemperature()` | Current device temperature | 3.0.0 |
| `resetSettings()` | Clear all settings on device | 4.0.0 |
| `factoryReset()` | Do a device factory reset | 4.0.0 |
| `getBrand()` | Information about device brand | 5.7.0 |
:::

## Examples
<div class="row d-flex align-content-stretch force-padding-10">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/basics/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Basic usage of management API</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

<div class="row d-flex align-content-stretch force-padding-10">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/js-management-getters/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Getting basic management API data</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

<div class="row d-flex align-content-stretch force-padding-10">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/management-js-api/js-management-setters/">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Setting basic management API data</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

## supports()
Method `supports()` will show you what capabilities the deployed device currently has.

::: table-responsive
|      Param     | Type                           |Description                   |
| -------------- | ----------------------------- | ---------------------------- |
| `capability`     | String                       | Name of capability |
:::

### Javascript example
```javascript
await sos.management.supports("NETWORK_INFO"); // Returns boolean
```

## getModel()
Method `getModel()` will display the model of your device.

```javascript
await sos.management.getModel(); // Returns string ex. Philips-10BDL3051T
```

## getSerialNumber()
Method `getSerialNumber()` will display device's serial number.

```javascript
await sos.management.getSerialNumber(); // Returns string ex. AU1A1xxxxxx07502
```


## getBatteryStatus()
Method `getBatteryStatus()` will display information about device's battery.

```javascript
await sos.management.getBatteryStatus(); // Returns object
```

### Example of response
```json
{
	"chargeType": "AC",
	"isCharging": true,
	"lastChargingTime": "2019-02-01T19:27:30.393Z",
	"percentage": 100,
	"updatedAt": "2019-02-01T19:27:31.247Z"
}
```

## getTemperature() 
Method `getTemperature()` will display information about the current temperature of the device. 

```typescript
await sos.management.getTemperature(); // Returns number values 0-100
```

## getBrand()
Method `getBrand()` will display the manufacturer brand of your device.

```typescript
await sos.management.getBrand(); // Returns string ex. Google, Samsung, signageOS for emulators
```
