---
title:  Video streams
author: Miroslav Behina
date:   22.11.2018
type:   js-api
tags:
- applet
- applet_api
- api
- js_api
description: "[Content JS API] Methods to play or stop video streams."
---

# Video streams
Methods to play or stop video streams.

## All methods
::: table-responsive
| Methods            | Description                                                      | Supported since |
| ------------------ | ---------------------------------------------------------------- | --------------- |
| `prepare()`        | Prepare video stream in the background                           | 4.7.0           |
| `play()`           | Start playing video stream                                       | 1.0.18          |
| `stop()`           | Stop video stream                                                | 1.0.18          |
| `onConnected()`    | Calls a listener callback when stream connects                   | 1.0.20          |
| `onDisconnected()` | Calls a listener callback when stream disconnects                | 1.0.20          |
| `onError()`        | Calls a listener callback when an unexpected stream error occurs | 1.0.20          |
| `onPlay()`         | Calls a listener callback when stream starts playing             | 5.12.0          |
| `onStop()`         | Calls a listener callback when stream stops                      | 5.12.0          |
| `onPrepare()`      | Calls a listener callback when stream prepares                   | 5.12.0          |
:::

::: alert alert--warning
Are you using **Samsung Tizen** to play streams? [Read more about limitation and Tizen-specific details](https://docs.signageos.io/hc/en-us/articles/4405387373458).
:::

## prepare()
Calls the internal player and prepares a video stream in memory, so it can later start playing instantaneously.

::: alert alert--info
If you want to play a video stream in full screen mode, use x = y = 0 and width = document.documentElement.clientWidth and height = document.documentElement.clientHeight as setup parameters.
:::

### Parameters
::: table-responsive
|      Param     | Type                        | Required                     | Description                                   |
| -------------- | --------------------------- | :--------------------------: | --------------------------------------------- |
| `uri`          | String                      | <div class="red">Yes</div>   | Network address where the stream is available |
| `x`            | Number                      | <div class="red">Yes</div>   | Stream x-position on the screen               |
| `y`            | Number                      | <div class="red">Yes</div>   | Stream y-position on the screen               |
| `width`        | Number                      | <div class="red">Yes</div>   | Stream width on the screen 	                  |
| `height`		 | Number                      | <div class="red">Yes</div>   | Stream height on the screen 	              |
| `protocol`     | String                      | <div class="red">Yes</div> | Protocol that the stream is using             |
|^^|^^|^^| Types: `HLS`, `RTP`, `HTTP`, `UDP`, `RTMP`, `RTSP`. |
| `options`      | Object                      | <div class="red">No</div>    | Additional options for the stream             |
:::

### Options object
::: table-responsive
|      Key        | Type                        | Required                     | Description                                   |
| ------------    | --------------------------- | :--------------------------: | --------------------------------------------- |
| `background`    | Boolean                     | <div class="red">No</div>    | Prepare stream in the background              |
:::

### Javascript syntax
```javascript
await sos.stream.prepare(uri,  x,  y,  width,  height,  protocol);

// Example with options - prepare stream in the background
await sos.stream.prepare(uri,  x,  y,  width,  height,  protocol,  { background: true });
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/content-js-api/stream">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Working example on our Github</h3>
                <div class="wide-box__description">Stream video Applet example</div>
            </div>
            </div>
        </a>
    </div>
</div>

## play()
Calls the internal player and starts a video stream in correct position.

::: alert alert--info
If you want to play a video stream in full screen mode, use x = y = 0 and width = document.documentElement.clientWidth and height = document.documentElement.clientHeight as setup parameters.
:::

### Parameters
::: table-responsive
|      Param     | Type                        | Required                     | Description                                   |
| -------------- | --------------------------- | :--------------------------: | --------------------------------------------- |
| `uri`          | String                      | <div class="red">Yes</div>   | Network address where the stream is available |
| `x`            | Number                      | <div class="red">Yes</div>   | Stream x-position on the screen               |
| `y`            | Number                      | <div class="red">Yes</div>   | Stream y-position on the screen               |
| `width`        | Number                      | <div class="red">Yes</div>   | Stream width on the screen 	                  |
| `height`		 | Number                      | <div class="red">Yes</div>   | Stream height on the screen 	              |
| `protocol`     | String                      | <div class="red">Yes</div> | Protocol that the stream is using             |
|^^|^^|^^| Types: `HLS`, `RTP`, `HTTP`, `UDP`, `RTMP`, `RTSP`. |
| `options`      | Object                      | <div class="red">No</div>    | Additional options for the stream             |
:::

### Options object
::: table-responsive
|      Key        | Type                        | Required                     | Description                                   |
| ------------    | --------------------------- | :--------------------------: | --------------------------------------------- |
| `autoReconnect` | Boolean                     | <div class="red">No</div>    | Automatically reconnect stream when it disconnects |
|^^|^^|^^| Default value: false |
| `autoReconnectInterval` | Number              | <div class="red">No</div>    | Interval in miliseconds between reconnect attempts |
|^^|^^|^^| Default value: 30000 ms |
:::

### Javascript syntax
```javascript
await sos.stream.play(uri,  x,  y,  width,  height,  protocol);

// Example with options - enable auto reconnect
await sos.stream.play(uri,  x,  y,  width,  height,  protocol,  { autoReconnect: true });

// Example with options - reconnect every 10 seconds
await sos.stream.play(uri,  x,  y,  width,  height,  protocol,  { autoReconnect: true, autoReconnectInterval: 10000 });
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/content-js-api/stream">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Working example on our Github</h3>
                <div class="wide-box__description">Stream video Applet example</div>
            </div>
            </div>
        </a>
    </div>
</div>

## stop()
Stops the video stream playback. 

### Javascript syntax
```javascript
await sos.stream.stop(uri,  x,  y,  width,  height);
```

### Parameters:
::: table-responsive
|      Param     | Type                        | Required     | Description                                                 |
| -------------- | --------------------------- | :------------------------: | --------------------------------------------- |
| `uri`          | String                      | <div class="red">Yes</div> | Network address where the stream is available |
| `x`            | Number                      | <div class="red">Yes</div> | Stream x-position on the screen               |
| `y`            | Number                      | <div class="red">Yes</div> | Stream y-position on the screen               |
| `width`        | Number                      | <div class="red">Yes</div> | Stream width on the screen 	                |
| `height`		 | Number                      | <div class="red">Yes</div> | Stream height on the screen 	                |
:::

## Event onConnected()
Calls a listener callback everytime `connected` event is emitted.

### Javascript syntax
```javascript
sos.stream.onConnected((event) => {
    // do something
});
```

## Event onDisconnected()
Calls a listener callback everytime `disconnected` event is emitted.

### Javascript syntax
```javascript
sos.stream.onDisconnected((event) => {
    // do something
});
```

## Event onError()
Calls a listener callback everytime `error` event is emitted.

### Javascript syntax
```javascript
sos.stream.onError((event) => {
    // do something
});
```

## Event onPlay()
Calls a listener callback everytime `play` event is emitted.

### Javascript syntax
```javascript
sos.stream.onPlay((event) => {
    // do something
});
```

## Event onStop()
Calls a listener callback everytime `stop` event is emitted.

### Javascript syntax
```javascript
sos.stream.onStop((event) => {
    // do something
});
```

## Event onPrepare()
Calls a listener callback everytime `prepare` event is emitted.

### Javascript syntax
```javascript
sos.stream.onPrepare((event) => {
    // do something
});
```

## Stream events
All stream events have the same format.

`type` property contains string with the event type. Type can be `connected`, `disconnected` or `error`.

`srcArguments` property contains parameters of the source stream, that emitted the event.
That way, if multiple streams are playing at once, you can associate the events with each stream instance.

Example event:
```json
{
  "type": "connected",
  "srcArguments": {
    "uri": "<uri>",
    "x": 0,
    "y": 0,
    "width": 1920,
    "height": 1080,
    "protocol": "RTP",
    "options": {
        "background": false,
        "autoReconnect": true,
        "autoReconnectInterval": 30000,
    },
  }
}
```

## Usage with Typescript
You can also use all these methods with [signageOS TypeScript](https://docs.signageos.io/hc/en-us/articles/4405069154962#signageos-typescript).

```typescript
interface StreamEvent {
    type: 'connected' | 'disconnected' | 'error' | 'stop' | 'prepare' | 'play',
    srcArguments: {
        uri: string;
        x: number;
        y: number;
        width: number;
        height: number;
        protocol: string;
    },
    options?: {
        background?: boolean;
        autoReconnect?: boolean;
        autoReconnectInterval?: number;
    }
}
play(
	uri:  string;
	x:  number;
	y:  number;
	width:  number;
	height:  number;
	protocolType:  'HLS'  |  'RTP'  |  'HTTP'  |  'UDP'  |  'RTMP'  |  'RTSP';
    options?: {
        background?: boolean;
        autoReconnect?: boolean;
        autoReconnectInterval?: number;
    }
): Promise<void>;
stop(
	uri:  string,
	x:  number,
	y:  number,
	width:  number,
	height:  number
): Promise<void>;
onConnected(listener: (event: StreamEvent) => void): void;
onDisconnected(listener: (event: StreamEvent) => void): void;
onError(listener: (event: StreamEvent) => void): void;
onPlay(listener: (event: StreamEvent) => void): void;
onStop(listener: (event: StreamEvent) => void): void;
onPrepare(listener: (event: StreamEvent) => void): void;
```

## Errors
Although we are doing our best, following errors may occur when working with the video stream.

::: table-responsive
| Code | Type | Message |
| ---- | ---- | ------- |
| 41401 | AppletStreamError | Invalid stream protocol type: `protocol` |
| 51301 | InternalStreamError | Couldn't stop the stream before playing the new one. |
| 51301 | InternalStreamError | Couldn't stop the stream. |
:::
