---
title:  Video Inputs (PiP)
author: Miroslav Behina
date:   22.11.2018
type:   js-api
tags:
- applet
- applet_api
- api
- js_api
description: "[Content JS API] Display content from another device over HDMI, Display Port, or other port. PIP (Picture in Picture) functionality allows you to display content from the internal port while keeping signageOS on."
---

# Video Inputs and Internal Ports
Display content from another device over HDMI, Display Port, or other port. PIP (Picture in Picture) functionality allows you to display content from the internal port while keeping signageOS on.

## All methods
::: table-responsive
| Methods  | Description | Supported since |
| ----------------- | ----------- | :---------------: |
| `play()` | Method for starting stream | 1.0.18 |
| `stop()` | Method stops using the internal port. | 1.0.18 |
:::

## play() 
Method uses the same API as [video streams](/api/js/content/js-video-stream). Instead of URL (for stream), **specify an URI of the port** to display.

### Parameters
::: table-responsive
|      Param     | Type              | Required |Description                   |
| -------------- | -------------------| :----------: | ---------------------------- |
| `uri`          | String                     | <div class="red">Yes</div>  | Internal port URI            |
| `x`            | Number                      | <div class="red">Yes</div> | x-position for video on screen |
| `y`            | Number                      | <div class="red">Yes</div> | y-position for video on screen |
| `width`        | Number                      | <div class="red">Yes</div> | Video width on screen 		|
| `height`		 | Number                      | <div class="red">Yes</div> | Video height on screen 		|
:::

### Javascript example
```javascript
await sos.stream.play(uri,  x,  y,  width,  height);
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/content-js-api/stream-hdmi-port">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Stream HDMI port Applet example</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

## Valid URI values 

::: table-responsive
|   Value                 |   Description                   |
| ----------------------- | ------------------------------- |
| `internal://hdmi<number>` | HDMI                            |
| `internal://dp`          | DisplayPort                     |
| `internal://dvi`          | DVI                             |
| `internal://pc`           | PC or VGA                       |
:::

::: alert alert--warning
`<number>` has to be a value between 1 - 4, depending on which of the available HDMI ports you want to use.
:::

## stop() 
Method stops using the internal port.

### Parameters:
::: table-responsive
|      Param     | Type            | Required |Description                   |
| -------------- | -----------------| :------------: | ---------------------------- |
| `uri`            | String                     | <div class="red">Yes</div>  | Internal port URI             |
| `x`              | Number                     | <div class="red">Yes</div>  | x-position for video on screen |
| `y`              | Number                      | <div class="red">Yes</div> | y-position for video on screen |
| `width`          | Number                      | <div class="red">Yes</div> | Video width on screen 		|
| `height`		 | Number                      | <div class="red">Yes</div> | Video height on screen 		|
:::

### Javascript example
```javascript
await sos.stream.stop(uri,  x,  y,  width,  height);
```

## Internal port events
API reacts to events related to changes in internal port status. Events are only emitted for a currently playing internal port.

::: table-responsive
| Event                         | Description                                                                                     |
| ----------------------------- | ----------------------------------------------------------------------------------------------- |
| `disconnected()`              | Emmited when the port is disconnected or does not receive any signal                            |
| `connected()`                 | Emmited when the port is re-connected or starts receiving signal again after being disconnected |
| `error()`                     | Emmited when an error occurs, is emmited only once                                              |
:::

## Usage with Typescript
You can also use all these methods with [signageOS TypeScript](https://docs.signageos.io/hc/en-us/articles/4405069154962#signageos-typescript).
```typescript
onDisconnected(listener: (event: {
	type: 'disconnected';
	srcArguments: {
		uri: string;
		x: number;
		y: number;
		width: number;
		height: number;
	};
}) => void): void;
onConnected(listener: (event: { 
	type: 'connected'; 
	srcArguments: { 
		uri: string; 
		x: number; 
		y: number; 
		width: number; 
		height: number; 
	};
}) => void): void;
onError(listener: (event: {
	type: 'error';
	srcArguments: {
		uri: string;
		x: number;
		y: number;
		width: number;
		height: number;
	};
	errorMessage: string;
}) => void): void;
```

## Errors
Although we are doing our best, following errors may occur when playing content from the internal ports.

::: table-responsive
| Code | Type | Message |
| ---- | ---- | ------- |
| 51501 | InternalVideoError | Couldn't play the video. |
| 51503 | InternalVideoError | Couldn't stop the video. |
:::
