---
title: Proof of Play
author: Robert Pecha
date:  31.01.2023
type: js-api
tags:
- applet
- applet_api
- api
- js_api
description: "[Content JS API] You can use our Prooof of Play mechanism to log that some content was played on end device successfully or not. Our system includes important metadata about applet and device out-of-box to simplify solution of issues with content. You can use SignageOS to analyze, if, where, when and how long proposed content was playing in front of audience."
---

# All methods
::: table-responsive
| Methods | Description | Supported since |
| ----------- | ------------ | -----------|
| `recordItemPlayed()` | Log that content was played successfully | 5.5.1 |
:::

## recordItemPlayed()

Send provided information about played content along with additional metadata about current applet and device to SignageOS.

### Parameters

::: table-responsive
| Param     | Type   | Required                   | Description                                        |
| --------- | ------ | :------------------------: | -------------------------------------------------- |
| `options` | Object | <div class="red">Yes</div> | Object containing information about played content |
:::

### Options

Here is the options object defined as Typescript interface:

```typescript
interface IRecordItemOptions {
  name: string;
  customId?: string;
  type?: 'video' | 'image' | 'html' | 'custom';
  tags?: string[];
  fileName?: string;
  playbackSuccess?: boolean;
  errorMessage?: string;
}
```

### Javascript example
```javascript

await sos.proofOfPlay.recordItemPlayed({
  name: 'tesla-commercial-ad-christmas-campaign',
  customId: 'dBE43bFB3312VFfvd34bgGHJVV334cd2',
  type: 'video',
  tags: ['tesla', 'christmas'],
  fileName: 'tesla.mp4',
  playbackSuccess: false,
  errorMessage: 'Unsupported framerate 60fps',
});

```
