---
title:  IR Remote Control Input
author: Miroslav Behina
date:   22.11.2018
type:   js-api
tags:
- applet
- applet_api
- api
- js_api
description: "[Content JS API] For the specific logic of an application (games for example), binding the remote control inputs can be helpful."
---

# IR Remote Control Input
For the specific logic of an application (games for example), binding the remote control inputs can be helpful. 
Only a subset of all remote control keys is supported on the specific device. Only numerical digits are guaranteed to be supported. 
This feature must be tested by users on real devices.

## Event onKeyUp()

### Parameters

::: table-responsive
| Parameters | Type | Required | Description | Supported Since | 
| ------ | ------ | :--------: | -------- | :-----: |
| event (in listener) | Object | <div class="red">Yes</div> | Plain JS object containing keyCode as number and keyName as string and type of event (always keyup string) | 1.3.0 |
:::

### Javascript syntax
```javascript
await sos.input.onKeyUp((keyUpEvent) => {
  console.log(`Pressed: ${keyUpEvent.keyCode} (${keyUpEvent.keyName})`);
});
```

## Map of keyCodes:
| Name | Key code | Name | Key Code |
| ---- | :----: | ----- | :----: |
| UNKNOWN | 0 | OK | 15 |
| NUM_0 | 1 | YELLOW | 16 |
| NUM_1 | 2 | BLUE | 17 |
| NUM_2 | 3 | RED | 18 |
| NUM_3 | 4 | GREEN | 19 |
| NUM_4 | 5 | VOLUME_DOWN | 20 |
| NUM_5 | 6 | VOLUME_UP | 30 |
| NUM_6 | 7 | POWER | 31 |
| NUM_7 | 8 | POWER_OFF | 32 |
| NUM_8 | 9 | HOME | 33 |
| NUM_9 | 10 | EXIT | 34 |
| ARROW_LEFT | 11 | RETURN | 35 |
| ARROW_UP | 12 | BACKSPACE | 36 |
| ARROW_RIGHT | 13 | LOCK | 37 |
| ARROW_DOWN | 14 | | |

## Usage with Typescript
You can also use all these methods with [signageOS TypeScript](https://docs.signageos.io/hc/en-us/articles/4405069154962#signageos-typescript).

```typescript
interface IKeyUpEvent {
  type: 'keyup';
  keyCode: number;
  keyName: string;
}
interface IKeyUpEventListener {
  (event: IKeyUpEvent): void;
}
onKeyUp(listener: IKeyUpEventListener): void;
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/tree/master/examples/content-js-api/remote-control">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">IR Input handling</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>
