---
title:  Hardware
author: Miroslav Behina
date:   22.11.2018
type:   js-api
tags:
- applet
- applet_api
- api
- philips
- led
- js_api
description: "[Content JS API] Some platforms support special hardware, that can be easily managed by JS using sOS hardware API."
---

# Hardware
Some platforms support special hardware, that can be easily managed by JS using sOS hardware API.


## LED

Some Philips brand devices have LED lights built into them. The color of lights can be changed or disabled:

### All methods

::: table-responsive
| Method | Description | Supported since |
| ------ | -------- | :---------: |
| `setColor()` | Method supports a string in hexa format to display color of LED light or null value to not be disabled | 1.0.1 |
:::

### setColor()

::: table-responsive
| Param | Type | Required | Description |
| ------ | ------ | :--------: | -------- |
| `color` | string | <div class="red">Yes</div> | Color of LED to be set in CSS hexa format `#000000`. To disable LED pass null value instead. |
:::

#### Javascript example
```javascript
sos.hardware.led.setColor("#00FF00"); // For GREEN light
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/content-js-api/hardware-led">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Example of Applet with LED usage</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

## Errors
Although we are doing our best, following errors may occur when working with the hardware.

::: table-responsive
| Code | Type | Message |
| ---- | ---- | ------- |
| 50601 | InternalHardwareError | Unexpected error occurred when working with hardware. |
| 40601 | AppletHardwareError | Color must be string |
| 40602 | AppletHardwareError | Color must be in format #000000 or null, allowed are `/^[a-zA-Z0-9\.\-_]+$/g` |
:::
