---
title:  Browser
author: Miroslav Behina
date:   22.11.2018
type:   js-api
tags:
- applet
- applet_api
- api
- js_api
description: "[Content JS API] There are several use-cases when you need to open a web browser on a touch-enabled device (also known as a tablet). For these cases, you can use a custom web browser we built."
---

# Browser

There are several use-cases when you need to open a web browser on a touch-enabled device (also known as a tablet). 
For these cases, you can use a custom web browser we built. 
Default URL can be opened and even the whitelisting/blacklisting of certain domains is supported. 

## All methods
::: table-responsive
| Methods  | Description | Supported since |
| ----------------- | ----------- | -----  | :---------------: |
| `open()`        | Open page in integrated browser |      4.0.0    |
| `close()`        | Open page in integrated browser |      4.4.0    |
:::

## open()

::: alert alert--info
**This API is currently available on:**  
- Android devices with Android 5+ (Philips, Benq, Sharp, generic Android device)

**With some limitation you can use this API also on**  
- Samsung Tizen (SSSP 4 and above); where the website is just in fullscreen without an address bar or theme options (headless mode)
- LG webOS (webOS 3.0 and above); where the website is just in fullscreen without an address bar or theme options (headless mode)
- Raspberry Pi and NEC Compute Module; where the website is just in fullscreen without an address bar or theme options (headless mode)
:::

### Javascript
Simple opening some page ex. our main company page.
```javascript
sos.browser.open('https://www.signageos.io'); // Open link in the browser
```
<br>

Method `open()` also supports properties for browser. You can set height, width or CORS domains. All properties are optional.

::: table-responsive
| Property | Type | Description |
| -------- | ------ | -------- |
| `aclDomains` | Array | ? |
| `aclMode` | String | Can be only **blacklist** or **whitelist**. |
| `readOnlyAddressBar` | Boolean | Accessible address bar |
| `coordinates` | Object | Size of browser screen (only Raspberry Pi) |
| `idleTimeout` | Number | Timeout in milliseconds for loading page |
| `theme` | Object | Setting custom theme for Android |
| `headlessMode` | Boolean | Headless mode hides the entire address bar (default) |
| `canUserClose` | Boolean | Whether the user can manually close the browser. Default:<br>**Headless:** `false`<br>**With UI:** `true` |
| `clearData` | Boolean | Clear cache after the browser closes. Default:<br>**Headless:** `false`<br>**With UI:** `true` |
:::


```javascript
sos.browser.open('https://www.signageos.io', {
  aclDomains: ['google.com', 'yahoo.com'],
  aclMode: 'blacklist', // or 'whitelist'
  readOnlyAddressBar: true,
  coordinates: { // Supported only on Raspberry Pi and Android
    x: 0,
    y: 0,
    height: 500,
    width: 500,
  },
  // theme: { ... } // supported only on Android
  headlessMode: false, // supported only on Android
```

<div class="row d-flex align-content-stretch force-padding-20">
    <div class="col-12 d-flex">
        <a class="wide-box wide-box--white d-flex align-content-stretch widebox-kb-color" target="_blank" href="https://github.com/signageos/applet-examples/blob/master/examples/content-js-api/browser">
            <div>
                <div class="wide-box__image d-flex align-items-center">
                    <i class="fab fa-github svg-black"></i>
                </div>
            <div>
                <h3 class="wide-box__title wide-box__title__small pl-85">Example of Applet for using browser on Android</h3>
                <div class="wide-box__description">Working example on our Github</div>
            </div>
            </div>
        </a>
    </div>
</div>

### Browser themes usage with Typescript
You can also use all these methods with [signageOS TypeScript](https://docs.signageos.io/hc/en-us/articles/4405069154962#signageos-typescript).

::: alert alert--info
Browser themes are only available on Android devices.
:::

```typescript
type Color = string;

export type ITheme = {
	base?: 'light' | 'dark'; // Default light
	shape?: {
		cornerSize?: number; // Default 2
	};
	colors?: {
		primary?: Color;
		background?: Color;
		control?: Color;
	};
	widgets?: {
		editAddress?: {
			colors?: {
				background?: Color;
				text?: Color;
			};
		};
		buttonClose?: {
			colors?: {
				background?: Color | '@primary';
				text?: Color;
				icon?: Color;
			};
			icon?: 'none' | 'exit_to_app' | 'close' | 'cancel';
			text?: string;
		};
		progress?: {
			color?: Color | '@primary';
		};
	};
};

interface IOpenLinkOptions {
	aclDomains?: string[];
	aclMode?: 'blacklist' | 'whitelist';
	readOnlyAddressBar?: boolean;
	coordinates?: {
		x: number;
		y: number;
		width: number;
		height: number;
	};
	theme?: ITheme;
	headlessMode?: boolean;
	clearData?: boolean;
	canUserClose?: boolean;
}

open(uri: string, options?: IOpenLinkOptions): void;
```

## close()

Closing the Browser instance. The whole page is closed. If you call `open()` again, the page will be loaded from the beginning.

### Javascript
Simple opening some page ex. our main company page.
```javascript
sos.browser.close(); // Close the browser
```
<br>

## Errors
Although we are doing our best, following errors may occur when opening a link.

::: table-responsive
| Code | Type | Message |
| ---- | ---- | ------- |
| 40301 | AppletBrowserUriError | Property argument `uri` must be a string |
| 50301 | InternalBrowserOpenLinkError | Unexpected error occurred when opening `$$LINK$$` |
:::

