---
title:  JS SDK Home
author: Josef Kral
date:   4.2.2018
type:   rest-api
tags:
- rest_api
- js_api
- api
description: "[Content JS API] General introduction to signageOS JS API"
---
# Javascript SDK for Applet development

Javascript SDK gives you access to device's native features and functionalities. You can use the same functions across all devices with the same result.

::: alert alert--tip
All APIs are standardized and available across all [supported devices](https://docs.signageos.io/hc/en-us/sections/4405700629266-Supported-Devices).
:::

## Content-related JS APIs

Content-related APIs help you with content part of your application /Applet/. 

Universal APIs for File system, access to accelerated video playback, sensor management and more provide you with robust tool set for creating extensive experiences.

::: table-responsive
| Domain | Description |
| ------ | ----------- |
| **[Basic information](/api/js/content/latest/js-applet-basics)** | General information required to use the signageOS JS API |
| [Applet Resources](/api/js/content/latest/js-applet-resources) | Pre-load necessary files required by your HTML5 player/Applet |
| [Display](/api/js/content/latest/js-display) | Query features supported by the display |
| [DeviceInfo](/api/js/content/latest/js-device-info) | Device-related informations  |
| [Browser](/api/js/content/latest/js-browser) | Opening managed web-browser on Android devices inc. whitelisting, blacklisting and other features |
| [Command](/api/js/content/latest/js-command) | Sending business or technical logs through signageOS in secured offline-ready way |
| [File system](/api/js/content/latest/js-file-system) | Full-featured file system API including ZIP and folder management |
| [Fonts](/api/js/content/latest/js-loading-fonts) | Make it easy to load additional fonts into SoC devices |
| [Hardware](/api/js/content/latest/js-hardware) | Hardware-specific APIs like LED lights on Philips 10BDL |
| [Inputs](/api/js/content/latest/js-input) | Controller inputs like IR remote unified under one API |
| [Monitors](/api/js/content/latest/js-monitors) | Information about monitors |
| [Proof of Play](/api/js/content/latest/js-proof-of-play) | Proof of Play API |
| [Sensors](/api/js/content/latest/js-sensors) | Using sensors and IoT devices in your application  |
| [Serial](/api/js/content/latest/js-hardware-serial) | Control external devices via serial |
| [Synchronized playback](/api/js/content/latest/js-sync-playback) | API for creating synced playback and videowalls  |
| [Video Inputs aka PiP](/api/js/content/latest/js-video-inputs-internal-ports) | Show HDMI/DP/VGA as a part of your content via PiP feature |
| [Video Playback](/api/js/content/latest/js-video) | Playing accelerated gapless videos via native video player |
| [Video Streams](/api/js/content/latest/js-video-stream) | Playing video streams (RTSP, HLS, UDP) via native video player  |
:::

## Device control JS APIs

Device control features exposed via Javascript APIs.

::: alert alert--tip
For **Device Management** we strongly recommend using REST APIs. [See the REST API documentation here](https://api.docs.signageos.io).
:::

::: table-responsive
| Domain | Description |
| ------ | ----------- |
| [Management](/api/js/management/latest/1-js-management) | Information about the device and power action like Reboot, Restart,.. |
| [Firmware](/api/js/management/latest/2-js-management-firmware) | Get FW version and upgrade FW from remote location |
| [Remote Control](/api/js/management/latest/3-js-management-remote-control) | Manage IR Remote control functionality |
| [Display](/api/js/management/latest/4-js-management-power) | Manage display power - timers, restart and reboot |
| [Screen](/api/js/management/latest/5-js-management-screen) | Manage brightness, orientation and resolution, display on/off |
| [Time](/api/js/management/latest/6-js-management-time) | Set time, timezone and get current settings |
| [Volume](/api/js/management/latest/7-js-management-volume) | Control system volume level |
| [Package](/api/js/management/latest/8-js-management-package) | Install and manage packages |
| [Debug](/api/js/management/latest/9-js-management-debug) | Enable/disable debug mode |
| [Application](/api/js/management/latest/10-js-management-application) | Get application version and upgrade application from remote location |
| [Network](/api/js/management/latest/11-js-management-network) | Manage network settings |
| [Security](/api/js/management/latest/12-js-management-security) | Control system security (PIN code) |
| [Wi-Fi](/api/js/management/latest/13-js-management-wifi) | Manage Wi-Fi |
:::

# Testing Framework SDK

Write and then run **automated tests** for your applet on physical devices, streamlining your development and QA efforts.

See full [documentation on GitHub](https://github.com/signageos/test-framework)

# Node.JS SDK

Library which allows you to fully manage signageOS applets, devices, management & monitoring using Node.JS and REST API.

See full [documentation on GitHub](https://github.com/signageos/sdk)

# REST API

Large collection of REST API endpoints for device management and monitoring.

See full [documentation on Postman](https://api.docs.signageos.io)
